<?php
    $call_title = cs_get_option('call_title');
    $phone_no = cs_get_option('phone_no');
    $chat_icon = cs_get_option('chat_icon');
    $header_1_btn = cs_get_option('header_1_btn');
    $hd_search_icon_hidde = cs_get_option('hd_search_icon_hidde');
    $h_login = cs_get_option('h_login');
    $h_contact_title = cs_get_option('h_contact_title');
    $h_contact_info = cs_get_option('h_contact_info');
    $h_email_id = cs_get_option('h_email_id');
    $h_login = cs_get_option('h_login');
?>
<header class="main-header header-style-two">
    	
    <!-- Header Top -->
    <div class="header-top">
        <div class="auto-container">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <!-- Right Box -->
                <?php if(!empty($h_contact_title) || $h_contact_info):?>
                <div class="left-box">
                    <div class="call"><span><?php echo esc_html($h_contact_title);?></span> <a href="#"><?php echo wp_kses( $h_contact_info, true );?></a></div>
                </div>
                <?php endif;?>
                <!-- Right Box -->
                <div class="right-box d-flex align-items-center">
                    <!-- Email -->
                    <?php if(!empty($h_email_id['url']) || !empty($h_email_id['text'])):?>
                        <a href="mailto:<?php echo esc_url($h_email_id['url']);?>" class="email"><span class="icon fa fa-envelope-o"></span> <?php echo esc_html($h_email_id['text']);?></a>
                    <?php endif;?>
                    <!-- Login -->
                    <?php if(!empty($h_login['url']) || !empty($h_login['text'])):?>
                        <a class="login" href="<?php echo esc_url($h_login['url']);?>"><?php echo esc_html($h_login['text']);?></a>
                    <?php endif;?>
                    
                </div>
            </div>
        </div>
    </div>
    <!-- End Header Top -->
    
    <!-- Header Lower -->
    <div class="header-lower">
        
        <div class="auto-container">
            <div class="inner-container d-flex justify-content-between align-items-center">
                
                <!-- Logo Box -->
                <div class="logo-box d-flex align-items-center">
                    <!-- Nav Toggle -->
                    <div id="open_offcanvas">
                        <div class="bars-outer clearfix">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                    <div class="logo"><?php constim_logo();?></div>
                </div>
                
                <div class="nav-outer d-flex align-items-center">
                    
                    <!-- Main Menu -->
                    <nav class="main-menu show navbar-expand-md">
                        <div class="navbar-header">
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                        </div>
                        
                        <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                            <?php constim_main_menu();?>
                        </div>
                        
                    </nav>
                    <!-- Main Menu End-->
                    
                </div>
                
                <!-- Outer Box -->
                <div class="outer-box d-flex align-items-center">
                    
                    <!-- Phone Box -->
                    <?php if(!empty($call_title)):?>
                    <div class="phone-box">
                        <div class="box-inner">
                            <?php if(!empty($chat_icon['url'])):?>
                                <span class="icon"><img src="<?php echo esc_url($chat_icon['url']);?>" alt="<?php echo esc_attr($chat_icon['alt']);?>" /></span>
                            <?php endif;?>
                            <?php echo esc_html($call_title);?> <br>
                            <a class="phone" href="<?php echo esc_url($phone_no['url']);?>"><?php echo esc_html($phone_no['text']);?></a>
                        </div>
                    </div>
                    <!-- End Phone Box -->
                    <?php endif;?>
                    <!-- End Phone Box -->
                    
                    <!-- Contact Button -->
                    <?php if(!empty($header_1_btn['text']) || !empty($header_1_btn['url'])):?>
                    <div class="contact-button">
                        <a class="contact" href="<?php echo esc_url($header_1_btn['url']);?>"><?php echo esc_html($header_1_btn['text']);?></a>
                    </div>
                    <?php endif;?>
                    
                    <!-- Search Box -->
                    <div class="search-box-outer">
                        <div class="search-box-btn"><span class="flaticon-001-loupe"></span></div>
                    </div>
                    
                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><i class="fal fa-bars"></i></span></div>
                    
                </div>
                <!-- End Outer Box -->
                
            </div>
            
        </div>
    </div>
    <!-- End Header Lower -->
    
    <!-- Sticky Header  -->
    <div class="sticky-header">
        <div class="auto-container">
            <div class="d-flex justify-content-between align-items-center">
                <!-- Logo -->
                <div class="logo">
                    <?php constim_logo();?>
                </div>
                
                <!-- Right Col -->
                <div class="right-box">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav>
                    <!-- Main Menu End-->
                    
                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><i class="fal fa-bars"></i></span></div>
                </div>
                
            </div>
        </div>
    </div>
    <!-- End Sticky Menu -->

    <!-- Mobile Menu  -->
    <?php constim_mobile_menu();?>
    <!-- End Mobile Menu -->

</header>
<?php constim_offcanvas_menu(); constim_search_popup();?>