<?php
	$search_icon_switcher_v4 = cs_get_option('search_icon_switcher_v4');
	$header_button_v4 = cs_get_option('header_button_v4');
?>

<!-- Main Header / Header Style Four -->
<header class="main-header header-style-four">

    <!-- Header Lower -->
    <div class="header-lower">

        <div class="auto-container">
            <div class="inner-container d-flex justify-content-between align-items-center">

                <!-- Logo Box -->
                <div class="logo-box d-flex align-items-center">
                    <div class="logo">
	                    <?php constim_logo_v2();?>
                    </div>
                </div>

                <div class="nav-outer d-flex align-items-center">

                    <!-- Main Menu -->
                    <nav class="main-menu show navbar-expand-md">
                        <div class="navbar-header">
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                        </div>

                        <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
	                        <?php constim_main_menu();?>
                        </div>

                    </nav>
                    <!-- Main Menu End-->

                    <!-- Outer Box -->
                    <div class="outer-box d-flex align-items-center">

                       <?php if($search_icon_switcher_v4 == true):?>
                            <!-- Search Box -->
                            <div class="search-box-outer">
                                <div class="search-box-btn"><span class="flaticon-001-loupe"></span></div>
                            </div>
	                    <?php endif;?>

	                    <?php if(!empty($header_button_v4['text']) || !empty($header_button_v4['url'])):?>
                            <a class="lets-talk theme-btn" href="<?php echo esc_url($header_button_v4['url']);?>"><?php echo esc_html($header_button_v4['text']);?></a>
                        <?php endif; ?>

                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon"><i class="fal fa-bars"></i></span></div>

                    </div>
                    <!-- End Outer Box -->

                </div>
            </div>

        </div>
    </div>
    <!-- End Header Lower -->

    <!-- Sticky Header  -->
    <div class="sticky-header">
        <div class="auto-container">
            <div class="d-flex justify-content-between align-items-center">
                <!-- Logo -->
                <div class="logo">
	                <?php constim_logo();?>
                </div>

                <!-- Right Col -->
                <div class="right-box">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav>
                    <!-- Main Menu End-->

                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon"><i class="fal fa-bars"></i></span></div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Sticky Menu -->

    <!-- Mobile Menu  -->
	<?php constim_mobile_menu();?>
    <!-- End Mobile Menu -->

</header>
<!-- End Main Header / Header Style Two -->
<?php constim_search_popup();?>