<?php
	$footer_logo_v3 = cs_get_option('footer_logo_v3');
	$site_info_v3 = cs_get_option('site_info_v3');
	$social_icon_group_v3 = cs_get_option('social_icon_group_v3');
	$about_us_v3 = cs_get_option('about_us_v3');
	$about_content_v3 = cs_get_option('about_content_v3');
	$quick_link_v3 = cs_get_option('quick_link_v3');
	$quick_nav_v3 = cs_get_option('quick_nav_v3');
	$office_info_v3 = cs_get_option('office_info_v3');
	$office_info_group_v3 = cs_get_option('office_info_group_v3');
	$office_open_hour_v3 = cs_get_option('office_open_hour_v3');
	$office_open_hour_time_v3 = cs_get_option('office_open_hour_time_v3');
	$copywrite_text_v3 = cs_get_option('copywrite_text_v3');
?>

<!-- Footer Style Two -->
<footer class="footer-style-two">
    <div class="auto-container">

        <!-- Widgets Section -->
        <div class="widgets-section">
            <div class="row clearfix">
                <!-- Column -->
                <div class="big-column col-lg-6 col-md-12 col-sm-12">
                    <div class="row clearfix">

                        <!-- Footer Column -->
                        <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                            <div class="footer-widget links-widget">
                                <!-- Logo -->
                                <?php if (!empty($footer_logo_v3['url'])): ?>
                                <div class="logo"><a href="<?php echo home_url('/'); ?>"><img src="<?php echo esc_url($footer_logo_v3['url']); ?>" alt="" title=""></a></div>
                                <?php endif; ?>
                                <div class="text"><?php echo wp_kses($site_info_v3, true) ?></div>
                                <!-- Social Box -->
                                <ul class="social-box">
                                    <?php
                                        if (!empty($social_icon_group_v3) && is_array($social_icon_group_v3)):
                                            foreach ($social_icon_group_v3 as $social):
                                    ?>
                                        <li><a href="<?php echo esc_url($social['social_icon_link_v3']['url']) ?>" class="<?php echo esc_attr($social['social_icon_v3']) ?>"></a></li>
                                    <?php
                                            endforeach;
                                        endif;
                                    ?>
                                </ul>
                            </div>
                        </div>

                        <!-- Footer Column -->
                        <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                            <div class="footer-widget about-widget">
                                <h4><?php echo esc_html( $about_us_v3 ); ?></h4>
                                <div class="text"><?php echo esc_html( $about_content_v3 ); ?></div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Column -->
                <div class="big-column col-lg-6 col-md-12 col-sm-12">
                    <div class="row clearfix">

                        <!-- Footer Column -->
                        <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                            <div class="footer-widget links-widget">
                                <h4><?php echo esc_html( $quick_link_v3 ); ?></h4>
	                            <?php
		                            if(!empty($quick_nav_v3)){
			                            wp_nav_menu( array(
				                            'menu' => $quick_nav_v3,
				                            'menu_class'     =>'page-list',
			                            ) );
		                            }
	                            ?>
                            </div>
                        </div>

                        <!-- Footer Column -->
                        <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                            <div class="footer-widget contact-widget">
                                <h4><?php echo esc_html( $quick_link_v3 ); ?></h4>

                                <ul class="contact-list">
	                                <?php
		                                if (!empty($office_info_group_v3) && is_array($office_info_group_v3)){
		                                foreach ($office_info_group_v3 as $info){
	                                ?>
                                    <li><span class="icon <?php echo esc_attr($info['office_info_icon_v3']); ?>"></span> <?php echo wp_kses($info['office_info_text_v3'], true) ?></li>
			                        <?php
		                                    }
		                                }
	                                ?>
                                </ul>


                                <div class="timing">
                                    <strong><?php echo esc_html( $office_open_hour_v3 ); ?> </strong>
	                                <?php echo wp_kses( $office_open_hour_time_v3 , true ); ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="footer-bottom">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div class="copyright">
	            <?php
		            if(!empty($copywrite_text_v3)){
			            echo wp_kses( $copywrite_text_v3, true );
		            }else{
			            esc_html_e( 'Copyright ©2023 Themexriver. All Rights Reserved', 'constim' );
		            }
	            ?>
                </div>
                <!-- Social Box -->
                <ul class="social-box">
	                <?php
		                if (!empty($social_icon_group_v3) && is_array($social_icon_group_v3)):
			                foreach ($social_icon_group_v3 as $social):
				                ?>
                                <li><a href="<?php echo esc_url($social['social_icon_link_v3']['url']) ?>" class="<?php echo esc_attr($social['social_icon_v3']) ?>"></a></li>
			                <?php
			                endforeach;
		                endif;
	                ?>
                </ul>
            </div>
        </div>

    </div>
</footer>
<!-- End Footer Style Two -->