<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package constim
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="inner-box">
        <!-- Post Info -->
        <?php if(has_post_thumbnail()){?>
		<div class="post-info">
			<div class="post-inner">
				<div class="post-image">
					<?php constim_main_author_avatars(24);?>
				</div>
				<?php esc_html_e( 'By:', 'constim' );?> <span><?php the_author()?></span>
			</div>
		</div>
		<div class="upper-image">
			<?php the_post_thumbnail( 'constim-image-size-3' )?>
			<?php the_post_thumbnail( 'constim-image-size-3' )?>
		</div>		
		<?php }?>
        <div class="lower-content">
            <ul class="post-meta">
                <li><span class="icon fal fa-calendar-check fa-fw"></span><?php echo date(get_option('date_format')); ?></li>
				<li><span class="icon fa-solid fa-comments fa-fw"></span><?php esc_html_e('Comments', 'constim')?> (<?php echo esc_attr(get_comments_number());?>)</li>
            </ul>
            <div class="entry-content">
                <?php
                    the_content(
                        sprintf(
                            wp_kses(
                                /* translators: %s: Name of current post. Only visible to screen readers */
                                __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'constim' ),
                                array(
                                    'span' => array(
                                        'class' => array(),
                                    ),
                                )
                            ),
                            wp_kses_post( get_the_title() )
                        )
                    );

                    wp_link_pages(
                        array(
                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'constim' ),
                            'after'  => '</div>',
                        )
                    );
                ?>
            </div> 
            <!-- Post Share Options-->
            <div class="post-share-options">
                <div class="post-share-inner d-flex justify-content-between align-items-center flex-wrap">
                    <div class="tags">
                        <?php constim_entry_footer();?>
                    </div>
                    <?php if(function_exists('constim_post_share')){
                        constim_post_share();
                    }?>
                </div>
            </div>
            <?php 
                if(function_exists('constim_authore_info')){
                    constim_authore_info();
                }
            ?>            
        </div>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
