<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package constim
 */

?>


<article id="post-<?php the_ID(); ?>" <?php post_class('news-block style-two'); ?>>
	<div class="inner-box">
		<!-- Post Info -->
		<?php if(has_post_thumbnail()){?>
		<div class="post-info">
			<div class="post-inner">
				<div class="post-image">
					<?php constim_main_author_avatars(24);?>
				</div>
				<?php esc_html_e( 'By:', 'constim' );?> <span><?php the_author()?></span>
			</div>
		</div>
		<div class="image">
			<?php the_post_thumbnail( 'constim-image-size-3' )?>
			<?php the_post_thumbnail( 'constim-image-size-3' )?>
		</div>		
		<?php }?>
		<div class="lower-content">
			<ul class="post-meta">
				<li><span class="icon fal fa-calendar-check fa-fw"></span><?php echo date(get_option('date_format')); ?></li>
				<li><span class="icon fa-solid fa-comments fa-fw"></span><?php esc_html_e('Comments', 'constim')?> (<?php echo esc_attr(get_comments_number());?>)</li>
			</ul>
			<h3><a href="<?php the_permalink()?>"><?php the_title();?></a></h3>
			<div class="text"><?php the_excerpt();?></div>
			<a class="read-more" href="<?php the_permalink()?>"><?php esc_html_e( 'Read More', 'constim' );?></a>
		</div>
	</div>	
</article><!-- #post-<?php the_ID(); ?> -->
