<?php

require_once get_template_directory() . '/lib/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'constim_register_required_plugins' );

function constim_register_required_plugins() {

    $plugins = array(
        array(
			'name'               => esc_html__('Constim Tools', 'constim'),
			'slug'               => 'constim-tools',
			'source'             => ( 'https://themexriver.com/wp/constim/tools/plugin/constim-tools.zip' ),
			'required'           => true,
			'force_activation'   => false,
			'force_deactivation' => false,
		),
        array(
			'name'               => esc_html__('Envato Market', 'constim'),
			'slug'               => 'envato-market',
			'source'             => esc_url( 'https://goo.gl/pkJS33' ),
            'external_url'       => esc_url( 'https://goo.gl/pkJS33' ),
			'required'           => true,
		), 
        array(
            'name'               => esc_html__('Slider Revolution', 'constim'),
            'slug'               => 'revslider',
            'source'             => 'https://themexriver.com/wp/constim/tools/plugin/revslider.zip',
            'required'           => true,
        ), 
        array(
            'name'     => 'Elementor Website Builder',
            'slug'     => 'elementor',
            'required' => true,
        ),
       
        array(
            'name'     => esc_html__('Contact Form 7', 'constim'),
            'slug'     => 'contact-form-7',
            'required' => false,
        ),
        array(
            'name'     => esc_html__('SVG Support', 'constim'),
            'slug'     => 'svg-support',
            'required' => false,
        ),

        array(
            'name'     => esc_html__('MC4WP: Mailchimp for WordPress', 'constim'),
            'slug'     => 'mailchimp-for-wp',
            'required' => false,
        ),

        array(
            'name'     => esc_html__( 'One Click Demo Import', 'constim' ),
            'slug'     => 'one-click-demo-import',
            'required' => false,
        ),

    );

    $config = array(
        'id'           => 'constim',
        'default_path' => '',
        'menu'         => 'tgmpa-install-plugins',
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',

    );

    tgmpa( $plugins, $config );
}
