<?php
include_once( get_template_directory() . '/lib/ocdi/codestar.php');
function constim_ocdi_import_files() {
	return array(
		array(
			'import_file_name'             => 'Constim',
			'categories'                   => array( 'constim' ),
			'import_file_url'            => 'https://themexriver.com/wp/constim/tools/demos/content.xml',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'lib/ocdi/demo/widgets.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'lib/ocdi/demo/customizer.dat',
			'local_import_json'           => array(
				array(
					'file_path'   => trailingslashit( get_template_directory() ) . 'lib/ocdi/demo/codestar.json',
					'option_name' => 'constim',
				),
			),
			'import_preview_image_url'     => '',
			'import_notice'                => esc_html__( 'Import process may take 3-10 minutes. If you facing any issues please contact our support.After Import Succesfuly go to Appearance->Menu And Set your Menu', 'constim' ),
			'preview_url'                  => '',
		),
	);
}
add_filter( 'pt-ocdi/import_files', 'constim_ocdi_import_files' );

function constim_ocdi_after_import( $selected_import ) {
	// Assign constim menus to their locations where will be display.
    $main_menu  = get_term_by( 'name', 'Primary Menu', 'nav_menu' );

    set_theme_mod( 
        'nav_menu_locations', 
        array( 
            'primary' => $main_menu->term_id,
        ) 
    );

    // constim Assign front page and posts page Set
    $front_page_id	= get_page_by_title( 'Home' );

    $blog_page_id	= get_page_by_title( 'Blog' );


	if( class_exists('RevSliderSliderImport') ) {
		foreach(array('home-1','home-5') as $slider) {
			$file = get_template_directory() . '/lib/ocdi/slider/'.$slider.'.zip';
			if( file_exists($file) ) {
				$importer = new RevSliderSliderImport();
				$response = $importer->import_slider( true, $file );
			}
		}
    }


    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );
}
add_action( 'pt-ocdi/after_import', 'constim_ocdi_after_import' );

function constim_ocdi_before_content_import() {
    add_filter( 'wp_import_post_data_processed', 'constim_ocdi_wp_import_post_data_processed', 99, 2 );
}
add_action( 'pt-ocdi/before_content_import', 'constim_ocdi_before_content_import', 99 );

function constim_ocdi_wp_import_post_data_processed( $postdata, $data ) {
    return wp_slash( $postdata );
}

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );