<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package constim
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function constim_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'constim_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function constim_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'constim_pingback_header' );

/**
 * Authore Avater
 */
function constim_main_author_avatars($size) {
    echo get_avatar(get_the_author_meta('email'), $size);
}
  
add_action('genesis_entry_header', 'constim_post_author_avatars');


/**
 * Post Read Time
 */
function constim_reading_time() {	
	global $post;	
	$content = get_post_field( 'post_content', $post->ID );
	$word_count = str_word_count( strip_tags( $content ) );
	$readingtime = ceil($word_count / 200);
	if ($readingtime == 1) {
	$timer = esc_html(" min read");
	} else {
	$timer = esc_html(" min read");
	}
	$totalreadingtime = $readingtime . $timer;
	return $totalreadingtime;
}


/**
 * constim Single Post Nav
 */
function constim_single_post_pagination(){ 
    $constim_prev_post = get_previous_post();
    $constim_next_post = get_next_post();
	
?>

<!-- Blog More Posts -->
<div class="blog-more-posts">
	<div class="d-flex justify-content-between align-items-center">
		<a href="<?php echo esc_url(get_the_permalink($constim_prev_post));?>"><span class="fa-solid fa-arrow-left fa-fw"></span> &nbsp; <?php esc_html_e( 'Previous Project', 'constim' )?></a>
		<a href="<?php echo esc_url(get_the_permalink($constim_next_post));?>"><?php esc_html_e( 'Previous Project', 'constim' )?> &nbsp; <span class="fa-solid fa-arrow-right fa-fw"></span></span></a>
	</div>
</div>
<?php 
}


/**
 * Comment Message Box
 */
function constim_comment_reform( $arg ) {

	$arg['title_reply']   = esc_html__( 'Leave a comment', 'constim' );
	$arg['comment_field'] = '<div class="comments-form"><div class="col-lg-12 col-md-12 col-sm-12 form-group"><div class="field-item"><textarea id="comment" class="form_control" name="comment" cols="77" rows="3" placeholder="' . esc_attr__( "Comment", "constim" ) . '" aria-required="true"></textarea></div></div></div>';

	return $arg;

}
add_filter( 'comment_form_defaults', 'constim_comment_reform' );
/**
 * Comment Form Field
 */

function constim_modify_comment_form_fields( $fields ) {
	$commenter = wp_get_current_commenter();
	$req       = get_option( 'require_name_email' );

	$fields['author'] = '<div class="comment-form"><div class="row"><div class="col-lg-4 col-md-6 col-sm-12 form-group"><div class="field-item"><input type="text" name="author" id="author" value="' . esc_attr( $commenter['comment_author'] ) . '" placeholder="' . esc_attr__( "Name", "constim" ) . '" size="22" tabindex="1"' . ( $req ? 'aria-required="true"' : '' ) . ' class="form_control" /></div></div>';

	$fields['email'] = '<div class="col-lg-4 col-md-6 col-sm-12 form-group"><div class="field-item"><input type="email" name="email" id="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '" placeholder="' . esc_attr__( "Email", "constim" ) . '" size="22" tabindex="2"' . ( $req ? 'aria-required="true"' : '' ) . ' class="form_control"  /></div></div>';

	$fields['url'] = '<div class="col-lg-4 col-md-6 col-sm-12 form-group"><div class="field-item"><input type="text" name="url" id="url" value="' . esc_attr( $commenter['comment_author_url'] ) . '" placeholder="' . esc_attr__( "Website", "constim" ) . '" size="22" tabindex="2"' . ( $req ? 'aria-required="false"' : '' ) . ' class="form_control"  /></div></div></div></div>';

	return $fields;
}
add_filter( 'comment_form_default_fields', 'constim_modify_comment_form_fields' );

// comment Move Field
function constim_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'constim_move_comment_field_to_bottom' );


/**
 * Comment List Modification
 */
function constim_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;?>

<div class="comment-box">
	<li <?php comment_class();?> id="comment-<?php comment_ID()?>">
			<?php if ( get_avatar( $comment ) ) {?>
				<div class="author-thumb">
					<?php echo get_avatar( $comment, 82 ); ?>
				</div>
			<?php }?>

			<div class="comments-text">
				<div class="comment-info clearfix">
					<strong><?php comment_author_link()?></strong>
					<div class="comment-time"><?php echo date(get_option('date_format')); ?></div>
					
				</div>  
				<?php if ( $comment->comment_approved == '0' ): ?>
					<p><em><?php esc_html_e( 'Your comment is awaiting moderation.', 'constim' );?></em></p>
				<?php endif;?>
				<div class="text">
					<?php comment_text();?>
				</div>
				<div class="post-options">
					<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => wp_kses('Reply', true) ) ) );?>
				</div>
			</div>
	</li>
	
	</div>

<?php
}


/**
 * Search Widget
 */
function constim_search_widgets( $form ) {
    $form = '
	<div class="search-box">
		<form role="search" method="get" id="searchform" class="widget__search" action="' . home_url( '/' ) . '" >
			<div class="form-group">
				<input class="form_control" placeholder="' .esc_attr__( 'Search Product', 'constim' ) . '" type="text"  value="' . get_search_query() . '" name="s" id="s" />
				<button type="submit"><span class="icon fa fa-search"></span></button>
			</div>
		</form>
    </div>
	';

    return $form;
}
add_filter( 'get_search_form', 'constim_search_widgets', 100 );

/**
 * constim Pagination
 */
function constim_pagination() {
    global $wp_query;
    $links = paginate_links( array(
    'current'   => max( 1, get_query_var( 'paged' ) ),
    'total'     => $wp_query->max_num_pages,
    'type'      => 'list',
    'mid_size'  => 3,
    'prev_text' => '<i class="fal fa-angle-double-left"></i>',
    'next_text' => '<i class="fal fa-angle-double-right"></i>',
    ) );

    echo wp_kses_post( $links );
}


/**
 * Category Count Markup
 */
function constim_category_html( $links ) {
    $links = str_replace( '</a> (', ' <span class="number">[ ', $links );
    $links = str_replace( ')', ' ]</span></a>', $links );
    return $links;
}
add_filter( 'wp_list_categories', 'constim_category_html' );

/**
 * Archive Count Markup
 */
function constim_archive_html($links) {
    $links = str_replace('</a>&nbsp;(', ' <span class="number">[ ', $links);
    $links = str_replace(')', ' ]</span></a>', $links);
    return $links;
}

add_filter('get_archives_link', 'constim_archive_html');