<?php

// File Security Check
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

function constim_custom_style() {

    //
    // Enqueueing StyleSheet file
    //
    wp_enqueue_style( 'constim-theme-custom-style', get_template_directory_uri() . '/assets/css/custom-style.css' );
    $css_output = '';
    $preloader__img = cs_get_option('preloader__img'); 
    $constim_color_1 = cs_get_option('constim_color_1'); 
    $constim_color_2 = cs_get_option('constim_color_2'); 
    $constim_color_3 = cs_get_option('constim_color_3'); 
    
    //BOdy COlor
    if(!empty($preloader__img['url'])){
        $css_output .= '        
        .preloader{
            background-image:url('.esc_url($preloader__img['url']).');
        }
        ';
    }
    if(!empty($constim_color_1) || !empty($constim_color_2) || !empty($constim_color_2)){
        $css_output .= '        
            :root {
                --main-color:'.esc_attr($constim_color_1).';
                --main-color-two:'.esc_attr($constim_color_2).';
                --color-twentythree:'.esc_attr($constim_color_3).';
            }
        ';
    }
    

    wp_add_inline_style( 'constim-theme-custom-style', $css_output );

}
add_action( 'wp_enqueue_scripts', 'constim_custom_style' );
