<?php

/**
 *
 * Get constim Theme options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_get_option' ) ) {
    function cs_get_option( $option = '', $default = null ) {
        $options = get_option( 'constim_theme_options' ); // Attention: Set your unique id of the framework
        return ( isset( $options[$option] ) ) ? $options[$option] : $default;
    }
}

/**
 *
 * Get get switcher option
 *  for theme options
 * @since 1.0.0
 * @version 1.0.0
 *
 */

if ( ! function_exists( 'cs_get_switcher_option' )) {

    function cs_get_switcher_option( $option = '', $default = null ) {
        $options = get_option( 'constim_theme_options' ); // Attention: Set your unique id of the framework
        $return_val =  ( isset( $options[$option] ) ) ? $options[$option] : $default;
        $return_val =  (is_null($return_val) || '1' == $return_val ) ? true : false;;
        return $return_val;
    }
}

if ( ! function_exists( 'cs_switcher_option' )) {

    function cs_switcher_option( $option = '', $default = null ) {
        $options = get_option( 'constim_theme_options' ); // Attention: Set your unique id of the framework
        $return_val =  ( isset( $options[$option] ) ) ? $options[$option] : $default;
        $return_val =  ( '1' == $return_val ) ? true : false;;
        return $return_val;
    }
}


/**
 * Function for get a metaboxes
 *
 * @param $prefix_key Required Meta unique slug
 * @param $meta_key Required Meta slug
 * @param $default Optional Set default value
 * @param $id Optional Set post id
 *
 * @return mixed
 */
function constim_get_meta( $prefix_key, $meta_key, $default = null, $id = '' ) {
    if ( !$id ) {
        $id = get_the_ID();
    }

    $meta_boxes = get_post_meta( $id, $prefix_key, true );
    return ( isset( $meta_boxes[$meta_key] ) ) ? $meta_boxes[$meta_key] : $default;
}

/**
 * Get Header layout
 *
 * @return string
 */
function constim_site_header() {
    $headers_layout = cs_get_option( 'header_glob_style', 'header-style-one' );
    if ( is_page() ) {
        $page_header = constim_get_meta( 'constim_page_meta', 'header_layout', 'default' );

        if ( 'default' !== $page_header ) {
            $headers_layout = $page_header;
        }
    }

    return $headers_layout;
}

/**
 * Get Header layout
 *
 * @return string
 */
function constim_site_footer() {
    $footer_layout = cs_get_option( 'footer_glob_style', 'footer-style-one' );
    if ( is_page() ) {
        $page_header = constim_get_meta( 'constim_page_meta', 'footer_layout', 'default' );

        if ( 'default' !== $page_header ) {
            $footer_layout = $page_header;
        }
    }

    return $footer_layout;
}

 /**
  * Site Logo
  */
function constim_logo(){ 
    $global_logo = cs_get_option('theme_logo');
    $page_main = constim_get_meta( 'constim_page_meta', 'page_logo', 'default' );
    ?>
    <?php if(!empty($page_main['url'])):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
            <img src="<?php echo esc_url($page_main['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php elseif(isset($global_logo['url']) && $global_logo['url']):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
        <img src="<?php echo esc_url($global_logo['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php else:?>
        <?php 
            if(has_custom_logo()){
                the_custom_logo();
            }else{ ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo.svg" alt="<?php esc_attr_e('Logo', 'constim'); ?>">
            </a>
        <?php    }
        ?>
    <?php endif;?>
<?php }


 /**
  * Site Logo
  */
function constim_logo_v2(){ 
    $global_logo = cs_get_option('theme_v2_logo');
    $page_main = constim_get_meta( 'constim_page_meta', 'page_logo', 'default' );
    ?>
    <?php if(!empty($page_main['url'])):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
            <img src="<?php echo esc_url($page_main['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php elseif(isset($global_logo['url']) && $global_logo['url']):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
        <img src="<?php echo esc_url($global_logo['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php else:?>
        <?php 
            if(has_custom_logo()){
                the_custom_logo();
            }else{ ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo.svg" alt="<?php esc_attr_e('Logo', 'constim'); ?>">
            </a>
        <?php    }
        ?>
    <?php endif;?>
<?php }

 /**
  * Footer Logo
  */
function constim_footer_logo(){ 
    $global_logo = cs_get_option('footer_theme_logo');
    $page_main = constim_get_meta( 'constim_page_meta', 'page_footer_logo', 'default' );
    ?>
    <?php if(!empty($page_main['url'])):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
            <img src="<?php echo esc_url($page_main['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php elseif(isset($global_logo['url']) && $global_logo['url']):?>
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
        <img src="<?php echo esc_url($global_logo['url']);?>" alt="<?php echo esc_attr(get_bloginfo());?>">
        </a>
    <?php else:?>
        <?php 
            if(has_custom_logo()){
                the_custom_logo();
            }else{ ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" >
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/footer.svg" alt="<?php esc_attr_e('Logo', 'constim'); ?>">
            </a>
        <?php    }
        ?>
    <?php endif;?>
<?php }

 /**
  * Sidebar Layout
  */
function constim_sidebar_layout(){ 
    $global_layout = cs_get_option('constim_blog_layout');
    $meta_layout = constim_get_meta( 'constim_page_meta', 'page_footer_logo', 'default' );
    ?>
    <?php if(!empty($meta_layout)):?>
        
    <?php elseif(isset($global_layout['url']) && $global_logo['url']):?>
        
    <?php else:?>
        
    <?php endif;?>
<?php }
