<?php 

function constim_preloader(){ 
$preloader_enable = cs_get_option('preloader_enable');
if($preloader_enable == true):
?>
  <div class="constim__preloader">
    <svg class="pl" width="240" height="240" viewBox="0 0 240 240">
      <circle class="pl__ring pl__ring--a" cx="120" cy="120" r="105" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 660" stroke-dashoffset="-330" stroke-linecap="round" />
      <circle class="pl__ring pl__ring--b" cx="120" cy="120" r="35" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 220" stroke-dashoffset="-110" stroke-linecap="round" />
      <circle class="pl__ring pl__ring--c" cx="85" cy="120" r="70" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 440" stroke-linecap="round" />
      <circle class="pl__ring pl__ring--d" cx="155" cy="120" r="70" fill="none" stroke="#000" stroke-width="20" stroke-dasharray="0 440" stroke-linecap="round" />
    </svg>
  </div>
<?php 
endif;
}


/**
 * Main Menu
 *
 * @return void
 */
function constim_main_menu(){
    echo str_replace(['menu-item-has-children'], ['dropdown'], wp_nav_menu( array( 
        'echo'           => false,
        'theme_location' => 'primary', 
        'menu_id'        =>'constim-primary-menu',
        'menu_class'     =>'navigation clearfix',
        'container'=>false,
        'fallback_cb'    => 'Constim_Bootstrap_Navwalker::fallback',
    )) );	
}

/**
 * constim Header Option
 *
 * @return void
 */
function constim_header_option(){
    if('header-style-one' === constim_site_header()){
        get_template_part('template-parts/header/header', 'one');
    }elseif('header-style-two' === constim_site_header()){
        get_template_part('template-parts/header/header', 'two');
    }elseif('header-style-three' === constim_site_header()){
        get_template_part('template-parts/header/header', 'three');
    }elseif('header-style-four' === constim_site_header()){
        get_template_part('template-parts/header/header', 'four');
    }else{
        get_template_part('template-parts/header/header', 'one');
    }
}

/**
 * constim Header Option
 *
 * @return void
 */
function constim_footer_option(){
  if('footer-style-one' === constim_site_footer()){
      get_template_part('template-parts/footer/footer', 'one');
  }elseif('footer-style-two' === constim_site_footer()){
      get_template_part('template-parts/footer/footer', 'two');
  }elseif('footer-style-three' === constim_site_footer()){
      get_template_part('template-parts/footer/footer', 'three');
  }else{
      get_template_part('template-parts/footer/footer', 'one');
  }
}
function constim_search_popup(){ ?>
  <div class="search-popup">
    <div class="color-layer"></div>
    <button class="close-search"><span class="flaticon-020-x-mark"></span></button>
      <form method="post" action="<?php echo esc_url( home_url( '/' ) ); ?>">
        <div class="form-group">
          <input type="search" name="s" value="<?php the_search_query();?>" placeholder="<?php the_search_query();?>" placeholder="<?php esc_attr_e( 'Search Here', 'constim' )?>" required>
          <button type="submit"><i class="flaticon-001-loupe"></i></button>
        </div>
      </form>
  </div>
  <?php 
}


function constim_mobile_menu(){ ?>
  <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><span class="icon flaticon-020-x-mark"></span></div>
        <nav class="menu-box">
            <div class="nav-logo"><?php constim_logo();?></div>
            <!-- Search -->
            <div class="search-box">
                <form method="post" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <div class="form-group">
                        <input type="search" name="s" value="<?php the_search_query();?>" placeholder="<?php the_search_query();?>" placeholder="<?php esc_attr_e( 'Search Here', 'constim' )?>" required>
                        <button type="submit"><span class="icon flaticon-001-loupe"></span></button>
                    </div>
                </form>
            </div>
            <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
        </nav>
    </div>
  <?php 
}
/**
 * constim Footer Content Markup
 *
 * @return void
 */
function constim_footer_markup(){ 
  $footer_gallery = cs_get_option('footer-gallery');  
  $gallery_ids = explode( ',', $footer_gallery );
  $contact_title = cs_get_option('contact_title');  
  $footer_content_enable = cs_get_option('footer_content_enable');  
  $cf_f_email = cs_get_option('cf_f_email');  
  $f_newsletter_shortcode = cs_get_option('f_newsletter_shortcode');  
  $footer_cp_nav = cs_get_option('footer_cp_nav');  
  $footer_nav    = cs_get_option('footer_nav');
  $ft_phone_icon = cs_get_option('ft_phone_icon');
  $ft_phone_title = cs_get_option('ft_phone_title');
  $ft_phone_no = cs_get_option('ft_phone_no');
  $f_logo_icon = cs_get_option('f_logo_icon');
  $constim_copywrite_text = cs_get_option('constim_copywrite_text');

?>
  <div class="auto-container">
		<!-- Widgets Section -->
    
    <?php if($footer_content_enable == true):?>
		<div class="widgets-section">
		
			<!-- Upper Box -->
			<div class="upper-box">
				<div class="d-flex justify-content-between align-items-center flex-wrap">
          <?php if(!empty($contact_title) || $cf_f_email):?>
					  <div class="contact"><?php echo esc_html($contact_title);?> <a href="emailto:<?php echo esc_url($cf_f_email);?>"><?php echo esc_html($cf_f_email);?></a></div>
          <?php endif;?>
					<div class="logo">
						<?php constim_footer_logo();?>
					</div>
					<!-- Subscribe Box -->
          <?php if(!empty($f_newsletter_shortcode)):?>
            <div class="subscribe-box">
              <div class="form-group">
                <?php echo do_shortcode( $f_newsletter_shortcode );?>
              </div>              
            </div>
          <?php endif;?>
				</div>
			</div>
			<!-- End Upper Box -->
			
			<!-- Middle Box -->
			<div class="middle-box">
				<div class="row clearfix">
					
					<!-- Gallery Block -->
            <?php foreach($gallery_ids as $gal):?>
           <div style="color:white;" class="text">EMT Boru, IMC Boru, RSC Boru, buat, aksesuar, fittings ve montaj malzemeleri için tüm ihtiyaçlarınızı tek yerden karşılayabileceğiniz sektör lideridir.</div>
					  <?php endforeach;?>
				</div>
			</div>
			
			<!-- Lower Box -->
			<div class="lower-box">
				<div class="d-flex justify-content-between align-items-center flex-wrap">
					<!-- logo -->
          <?php if(!empty($f_logo_icon['url'])):?>
					<div class="logo">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($f_logo_icon['url']);?>" alt="<?php echo esc_attr($f_logo_icon['alt']);?>" /></a>
					</div>
          <?php endif;?>
					<!-- Footer Nav -->
          <?php
            if(!empty($footer_nav)){
              wp_nav_menu( array(
                'menu' => $footer_nav,
                'menu_class'     =>'footer-nav',
              ) );
            }              
          ?>
					
					<!-- Phone Box -->
          <?php if($ft_phone_icon):?>
					<div class="phone-box">
						<div class="box-inner">
              <?php if(!empty($ft_phone_icon['url'])):?>
							  <span class="icon"><img src="<?php echo esc_url($ft_phone_icon['url']);?>" alt="<?php echo esc_attr($ft_phone_icon['alt']);?>" /></span>
              <?php endif;?>
							<?php echo esc_html($ft_phone_title);?> <br>
							  <a href="tel:<?php echo esc_url($ft_phone_no);?>"><?php echo esc_html( $ft_phone_no )?></a>
						</div>
					</div>
					<?php endif;?>
				</div>
			</div>
			
		</div>
		<?php endif;?>
		<!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="row clearfix">
				<!-- Column -->
				<div class="column col-lg-6 col-md-12 col-sm-12">
					<div class="copyright">
            <?php 
                if(!empty($constim_copywrite_text)){
                    echo wp_kses( $constim_copywrite_text, true );
                }else{
                    esc_html_e( 'Copyright ©2023 Themexriver. All Rights Reserved', 'constim' );
                }
            ?> 
          </div>
				</div>
				<!-- Column -->
				<div class="column col-lg-6 col-md-12 col-sm-12">
          <?php
            if(!empty($footer_cp_nav)){
              wp_nav_menu( array(
                'menu' => $footer_cp_nav,
                'menu_class'     =>'footer-bottom-nav',
              ) );
            }
          ?>
				</div>
			</div>
		</div>
		
	</div>
<?php 
}

/**
 * Single Project
 *
 * @return void
 */
function constim_single_service_loop(){
  while ( have_posts() ) :
      the_post();

      get_template_part( 'template-parts/service', 'content' );

  endwhile; // End of the loop.
}

/**
 * Constim Blog Post
 *
 * @return void
 */
function constim_post_loop(){
  if ( have_posts() ) :

    /* Start the Loop */
    while ( have_posts() ) :
      the_post();

      /*
       * Include the Post-Type-specific template for the content.
       * If you want to override this in a child theme, then include a file
       * called content-___.php (where ___ is the Post Type name) and that will be used instead.
       */
      get_template_part( 'template-parts/content', get_post_type() );

    endwhile; ?>
    <div class="pagination-outer text-center">
      <div class="pagination">
        <?php constim_pagination();?>
      </div>
    </div>
    

  <?php else :

    get_template_part( 'template-parts/content', 'none' );

  endif;
}

/**
 * Single Post Loop
 *
 * @return void
 */
function constim_single_post(){
  while ( have_posts() ) :
    the_post();

    get_template_part( 'template-parts/content', 'single' );

    constim_single_post_pagination();

    // If comments are open or we have at least one comment, load up the comment template.
    if ( comments_open() || get_comments_number() ) :
      comments_template();
    endif;

  endwhile; // End of the loop.
}

/**
 * Single Breadcrumb
 *
 * @return void
 */
function constim_single_breadcrumb(){ 
  $single_breadcrumb_bg = cs_get_option('single_breadcrumb_bg');
  $single_breadcrumb_logo = cs_get_option('single_breadcrumb_logo');
?>
  <section class="page-title single__blog_br" <?php if(!empty($single_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($single_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($single_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($single_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($single_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1><?php the_title();?></h1>
		</div>
	</section>
  <?php 
}

/**
 * Single Breadcrumb
 *
 * @return void
 */
function constim_page_breadcrumb(){ 
  
?>
  <section class="page-title single__blog_br" <?php if(!empty($single_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($single_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($single_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($single_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($single_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1><?php the_title();?></h1>
		</div>
	</section>
  <?php 
}

/**
 * Single Breadcrumb
 *
 * @return void
 */
function constim_error_breadcrumb(){ 
    $er_custom_title = cs_get_option('er_custom_title');
?>
  <section class="page-title single__blog_br" <?php if(!empty($single_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($single_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($single_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($single_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($single_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1><?php if(!empty($er_custom_title)){echo esc_html($er_custom_title);}else{esc_html_e( '404', 'constim' );}?></h1>
		</div>
	</section>
  <?php 
}

/**
 * Single Breadcrumb
 *
 * @return void
 */
function constim_blog_breadcrumb(){ 
  $blog_breadcrumb_bg = cs_get_option('blog_breadcrumb_bg');
  $single_breadcrumb_logo = cs_get_option('single_breadcrumb_logo');
  $br_custom_title = cs_get_option('br_custom_title');
?>
  <section class="page-title" <?php if(!empty($blog_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($blog_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($blog_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($blog_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($blog_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1>
        <?php 
          if(!empty($br_custom_title)){
            echo esc_html($br_custom_title);
          }else{
            esc_html_e( 'Latest Blog', 'constim' );
          }
        ?>
      </h1>
		</div>
	</section>
  <?php 
}

/**
 * Search Breadcrumb
 *
 * @return void
 */
function constim_search_breadcrumb(){ 
  $blog_breadcrumb_bg = cs_get_option('blog_breadcrumb_bg');
  $single_breadcrumb_logo = cs_get_option('single_breadcrumb_logo');
?>
  <section class="page-title" <?php if(!empty($blog_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($blog_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($blog_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($blog_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($blog_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1>
        <?php
        /* translators: %s: search query. */
        printf( esc_html__( 'Search Results for: %s', 'constim' ), '<span>' . get_search_query() . '</span>' );
        ?>
      </h1>
		</div>
	</section>
  <?php 
}

/**
 * Search Breadcrumb
 *
 * @return void
 */
function constim_archive_breadcrumb(){ 
  $blog_breadcrumb_bg = cs_get_option('blog_breadcrumb_bg');
  $single_breadcrumb_logo = cs_get_option('single_breadcrumb_logo');
?>
  <section class="page-title" <?php if(!empty($blog_breadcrumb_bg['url'])):?> style="background-image: url(<?php echo esc_url($blog_breadcrumb_bg['url']);?>)" <?php endif;?>?>
		<div class="auto-container">
      <?php if(!empty($blog_breadcrumb_logo['url'])):?>
        <div class="icon">
          <img src="<?php echo esc_url($blog_breadcrumb_logo['url']);?>" alt="<?php echo esc_attr($blog_breadcrumb_logo['alt']);?>" />
        </div>
      <?php endif;?>
			<h1>
        <?php
            the_archive_title();
            the_archive_description( '<div class="archive-description">', '</div>' );
        ?> 
      </h1>
		</div>
	</section>
  <?php 
}

/**
 * Search Loop
 *
 * @return void
 */
function constim_search_loop(){ ?>
  
  <?php if ( have_posts() ) : ?>

    <?php
    /* Start the Loop */
    while ( have_posts() ) :
      the_post();

      /**
       * Run the loop for the search to output the results.
       * If you want to overload this in a child theme then include a file
       * called content-search.php and that will be used instead.
       */
      get_template_part( 'template-parts/content', 'search' );

    endwhile; ?>

    <div class="pagination-outer text-center">
      <div class="pagination">
        <?php constim_pagination();?>
      </div>
    </div>

  <?php else :

    get_template_part( 'template-parts/content', 'none' );

  endif;
  ?>
  <?php 
}


/**
 * Archive Loop
 *
 * @return void
 */
function constim_arcive_loop(){ ?>
  <?php if ( have_posts() ) : ?>

    <?php
    /* Start the Loop */
    while ( have_posts() ) :
      the_post();

      /*
       * Include the Post-Type-specific template for the content.
       * If you want to override this in a child theme, then include a file
       * called content-___.php (where ___ is the Post Type name) and that will be used instead.
       */
      get_template_part( 'template-parts/content', get_post_type() );

    endwhile; ?>

    <div class="pagination-outer text-center">
      <div class="pagination">
        <?php constim_pagination();?>
      </div>
    </div>

  <?php else :

    get_template_part( 'template-parts/content', 'none' );

  endif;
  ?>
  <?php
}

function constim_offcanvas_menu(){ 
  $contact_info_items = cs_get_option('contact_info_items');  
  $offc_social_icons = cs_get_option('offc_social_icons');  
  $is_enable_offcanvas_nav = cs_get_option('is_enable_offcanvas_nav');   
?>
  <!-- Offcanvas Area Start -->
	  <section class="offcanvas__area">
		<div class="close_offcanvas close-side-widget flaticon-020-x-mark" id="close_offcanvas"></div>
		<div class="offcanvas__inner">
		  <div class="offcanvas__left ">

			<div class="side__navbar-wrapper mean-container">
			  <nav class="side__navbar">
          <?php 
           echo str_replace(['menu-item-has-children'], ['main-dropdown'], wp_nav_menu( array( 
              'echo'           => false,
              'theme_location' => 'offcanvas_menu', 
              'menu_id'        =>'constim-primary-menu',
              'menu_class'     =>'navigation clearfix',
              'container'=>false,
              'fallback_cb'    => 'Constim_Bootstrap_Navwalker::fallback',
          )) );	
          ?>
			  </nav>
			</div>
		  </div>
		  <div class="offcanvas__right">
			<div class="offcanvas__logo">
        <?php constim_logo();?>
			</div>
			<div class="offcanvas__contact">
        <?php if(!empty($contact_info_items)):?>
          <ul class="info-list">
            <?php foreach($contact_info_items as $item):?>
              <li>
                <span class="icon <?php echo esc_attr($item['icons']);?>"></span>
                <span class="title"><?php echo wp_kses( $item['title'], true )?></span>
                <a><?php echo wp_kses( $item['infos'], true )?></a>
              </li>
            <?php  endforeach;?>
          </ul>
          <?php endif;?>
			  <!-- Social Box -->
        <?php if(!empty($offc_social_icons)):?>
          <ul class="social-box">
            <?php foreach($offc_social_icons as $item):?>
             <li><a href="<?php echo esc_url($item['link']);?>" class="<?php echo esc_attr($item['icon']);?>"></a></li>
            <?php  endforeach;?>
        </ul>
        <?php endif;?>
			</div>
		  </div>
		</div>
	  </section>
	  <!-- Offcanvas Area End -->
 <?php 
}


function constim_error_page(){ 
  $error_title = cs_get_option('error_title');     
  $error_code = cs_get_option('error_code');     
  $error_info_title = cs_get_option('error_info_title');     
  $error_button = cs_get_option('error_button');   
?>
  <div class="error-section">
    	<div class="auto-container">
        	<div class="content">
          <h1>
            <?php 
                if(!empty($error_code)){
                    echo esc_html( $error_code );
                }else{
                    esc_html_e( '404', 'constim' );
                }
            ?>
          </h1>
				<h2>
          <?php 
              if(!empty($error_title)){
                  echo esc_html( $error_title );
              }else{
                  esc_html_e( 'Oops... It looks like you ‘re lost !', 'constim' );
              }
          ?>  
        </h2>
				<div class="text">
        <?php 
              if(!empty($error_info_title)){
                  echo esc_html( $error_info_title );
              }else{
                  esc_html_e( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'constim' );
              }
          ?>  
          
        </div>
				<!-- Button Box -->
				<div class="button-box text-center">
					<a href="index.html" class="theme-btn btn-style-one">
						<span class="btn-wrap">
							<span class="text-one">
                <?php 
                    if(!empty($error_button)){
                        echo esc_html( $error_button );
                    }else{
                        esc_html_e( 'Go To Home', 'constim' );
                    }
                ?>  
              </span>
							<span class="text-two">
                <?php 
                    if(!empty($error_button)){
                        echo esc_html( $error_button );
                    }else{
                        esc_html_e( 'Go To Home', 'constim' );
                    }
                ?>  
              </span>
						</span>
					</a>
				</div>
			</div>
		</div>
	</div>
<?php 
}