<?php
/**
 * constim functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package constim
 */


/**
 * Define Core FIle
*/
define( 'CONSTIM_THEME_DRI', get_template_directory() );
define( 'CONSTIM_THEME_URI', get_template_directory_uri() );
define( 'CONSTIM_CSS_PATH',  CONSTIM_THEME_URI . '/assets/css' );
define( 'CONSTIM_JS_PATH',   CONSTIM_THEME_URI . '/assets/js' );
define( 'CONSTIM_ICON_PATH', CONSTIM_THEME_URI . '/assets/fonts/fontawesome/css' );
define( 'CONSTIM_IMG_PATH',  CONSTIM_THEME_URI . '/assets/images' );

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function constim_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on constim, use a find and replace
		* to change 'constim' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'constim', get_template_directory() . '/languages' );
	remove_theme_support( 'widgets-block-editor' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	//Custom add image size
	add_image_size( 'constim-image-size-1', 540, 440, true );
	add_image_size( 'constim-image-size-2', 430, 338, true );
	add_image_size( 'constim-image-size-3', 970, 477, true );
	add_image_size( 'constim-image-size-4', 353, 215, true );
	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'primary' => esc_html__( 'Primary Menu', 'constim' ),
			'offcanvas_menu' => esc_html__( 'Offcanvas Menu', 'constim' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'constim_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'constim_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function constim_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'constim_content_width', 640 );
}
add_action( 'after_setup_theme', 'constim_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function constim_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'constim' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'constim' ),
			'before_widget' => '<div id="%1$s" class="widget sidebar-widget style-two %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="sidebar-title"><h5>',
			'after_title'   => '</h5></div>',
		)
	);
	//Footer One
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer One', 'constim' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'constim' ),
			'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5>',
			'after_title'   => '</h5>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Two', 'constim' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'constim' ),
			'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5>',
			'after_title'   => '</h5>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Three', 'constim' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'constim' ),
			'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5>',
			'after_title'   => '</h5>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Four', 'constim' ),
			'id'            => 'footer-4',
			'description'   => esc_html__( 'Add widgets here.', 'constim' ),
			'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<h5>',
			'after_title'   => '</h5>',
		)
	);
}
add_action( 'widgets_init', 'constim_widgets_init' );


/**
 *Google Font Load 
 */
if ( ! function_exists( 'constim_fonts_url' ) ) :
	/**
	 * Register Google fonts for Blessing.
	 */
	function constim_fonts_url() {
		$fonts_url     = '';
		$font_families = array();
		$subsets       = 'latin';
	
		if ( 'off' !== _x( 'on', 'Syne: on or off', 'constim' ) ) {
			$font_families[] = 'Syne:400,500,600,700,800';
		}

		if ( 'off' !== _x( 'on', 'Manrope: on or off', 'constim' ) ) {
			$font_families[] = 'Manrope:200,300,400,500,600,700,800';
		}
		
	
		if ( $font_families ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $font_families ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}
	
		return esc_url_raw( $fonts_url );
	}
	endif;

/**
 * Enqueue scripts and styles.
 */
function constim_scripts() {
	//constim Google Font Load
	wp_enqueue_style( 'constim-google-fonts', constim_fonts_url(), array(), null );
	wp_enqueue_style( 'bootstrap', CONSTIM_CSS_PATH . '/bootstrap.css' );
	wp_enqueue_style( 'fontawesome-all', CONSTIM_CSS_PATH . '/fontawesome-all.css' );
	wp_enqueue_style( 'swiper', CONSTIM_CSS_PATH . '/swiper.css' );
	wp_enqueue_style( 'custom-animate', CONSTIM_CSS_PATH . '/custom-animate.css' );
	wp_enqueue_style( 'magnific-popup', CONSTIM_CSS_PATH . '/magnific-popup.css' );
	wp_enqueue_style( 'meanmenu', CONSTIM_CSS_PATH . '/meanmenu.min.css' );
	wp_enqueue_style( 'odometer-theme-default', CONSTIM_CSS_PATH . '/odometer-theme-default.css' );
	wp_enqueue_style( 'mcustomScrollbar', CONSTIM_CSS_PATH . '/jquery.mCustomScrollbar.min.css' );
	wp_enqueue_style( 'owl-caroulse', CONSTIM_CSS_PATH . '/owl.css' );
	wp_enqueue_style( 'animate', CONSTIM_CSS_PATH . '/animate.css' );
	wp_enqueue_style( 'flaticon', CONSTIM_CSS_PATH . '/flaticon.css' );
	wp_enqueue_style( 'constim-header', CONSTIM_CSS_PATH . '/header.css' );
	wp_enqueue_style( 'constim-footer', CONSTIM_CSS_PATH . '/footer.css' );
	wp_enqueue_style( 'constim-global', CONSTIM_CSS_PATH . '/global.css' );
	wp_enqueue_style( 'constim-main', CONSTIM_CSS_PATH . '/style.css' );
	wp_enqueue_style( 'constim-post-style', CONSTIM_CSS_PATH . '/post-style.css' );
	wp_enqueue_style( 'constim-responsive', CONSTIM_CSS_PATH . '/responsive.css' );

	// Js Enqueue
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('masonry');
	wp_enqueue_script( 'popper', CONSTIM_JS_PATH . '/popper.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'bootstrap', CONSTIM_JS_PATH . '/bootstrap.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'magnific-popup', CONSTIM_JS_PATH . '/magnific-popup.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'parallax', CONSTIM_JS_PATH . '/parallax.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'mcustomscrollbar', CONSTIM_JS_PATH . '/jquery.mCustomScrollbar.concat.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'appear', CONSTIM_JS_PATH . '/appear.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'isotope', CONSTIM_JS_PATH . '/isotope.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'owl', CONSTIM_JS_PATH . '/owl.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'gsap', CONSTIM_JS_PATH . '/gsap.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'wow', CONSTIM_JS_PATH . '/wow.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'splittext', CONSTIM_JS_PATH . '/SplitText.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'scrolltrigger', CONSTIM_JS_PATH . '/ScrollTrigger.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'scrolltoplugin', CONSTIM_JS_PATH . '/ScrollToPlugin.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'swiper', CONSTIM_JS_PATH . '/swiper.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'odometer', CONSTIM_JS_PATH . '/odometer.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'meanmenu', CONSTIM_JS_PATH . '/jquery.meanmenu.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'marquee', CONSTIM_JS_PATH . '/jquery.marquee.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'nav-tool', CONSTIM_JS_PATH . '/nav-tool.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'constim-script', CONSTIM_JS_PATH . '/script.js', array('jquery'), '1.0', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'constim_scripts' );

/**
 * Implement the Custom Header feature.
 */
require CONSTIM_THEME_DRI . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require CONSTIM_THEME_DRI . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require CONSTIM_THEME_DRI . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require CONSTIM_THEME_DRI . '/inc/customizer.php';

/**
 * constim Core Functions
 */
require CONSTIM_THEME_DRI . '/inc/constim-functions.php';

/**
 * constim Metabox & Options Fremworks
 */
require CONSTIM_THEME_DRI . '/inc/cs-framework-functions.php';

/**
 * constim Metabox & Options Fremworks
 */
require CONSTIM_THEME_DRI . '/inc/class-wp-constim-navwalker.php';

/**
 * Custom Style
 */
require CONSTIM_THEME_DRI . '/inc/custom-style.php';

/**
 * Recommended Plugin Activation
 */
require CONSTIM_THEME_DRI . '/lib/plugin-activation.php';
/**
 * constim Theme Dynamic Style
 */
require CONSTIM_THEME_DRI . '/lib/ocdi/functions.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require CONSTIM_THEME_DRI . '/inc/jetpack.php';
}
