<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package constim
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-wrap">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<div class="comments-area">
			<div class="group-title">
				<h4 class="comments-title">
					<?php
					$constim_comment_count = get_comments_number();
					if ( '1' === $constim_comment_count ) {
						printf(
							/* translators: 1: title. */
							esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'constim' ),
							'<span>' . wp_kses_post( get_the_title() ) . '</span>'
						);
					} else {
						printf( 
							/* translators: 1: comment count number, 2: title. */
							esc_html( _nx( '%1$s Comment', '%1$s Comments', $constim_comment_count, 'comments title', 'constim' ) ),
							number_format_i18n( $constim_comment_count ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							'<span>' . wp_kses_post( get_the_title() ) . '</span>'
						);
					}
					?>	
				</h4><!-- .comments-title -->
			</div>
		
			<?php the_comments_navigation(); ?>
			<ol class="comment-list">
				<?php
				wp_list_comments(
					array(
						'callback' => 'constim_comments',
					)
				);
				?>
			</ol><!-- .comment-list -->
			</div>

		<?php
		the_comments_navigation();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'constim' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().
	$args = array(
		'comment_notes_after' => '<div class="button-box"><button class="theme-btn">
		'.esc_html('Post Comment').'
	</button></div>' 
	);
	comment_form($args);
	?>

</div><!-- #comments -->
