<?php
/*
 * Theme Options
 * @package constim
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {


    //
    // Set a unique slug-like ID
    $prefix = 'constim';

    //
    // Create options
    CSF::createOptions( $prefix . '_theme_options', array(
        'menu_title'         => 'Constim Option',
        'menu_slug'          => 'constim-theme-option',
        'menu_type'          => 'menu',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'menu_position' => 50,
        'theme'                   => 'dark',
        'framework_title'    => wp_kses_post( 'Constim Options <small>by Raziul <br/> Version: 1.0</small> ' ),
        'footer_text'    => wp_kses_post( 'The Theme will Created By Themexriver ' ),
    ) );

    // Create a top-tab
    CSF::createSection( $prefix . '_theme_options', array(
        'id'    => 'header_opts', // Set a unique slug-like ID
        'title' => 'Header',
    ) );


    /*-------------------------------------------------------
     ** Logo Settings  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Logo Settings', 'constim-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Site Logo', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'theme_logo',
                'title'   => esc_html__( 'Main Logo', 'constim-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Your Main Logo Here', 'constim-tools' ),
            ),

            array(
                'id'      => 'theme_v2_logo',
                'title'   => esc_html__( 'Main Logo V2', 'constim-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Your Main Logo Here', 'constim-tools' ),
            ),
            
        ),
    ) );

    /*-------------------------------------------------------
     ** Header  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Header', 'constim-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header Layout', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'          => 'header_glob_style',
                'type'        => 'select',
                'title'       => 'Choose Header',
                'chosen'      => true,
                'placeholder' => 'Header Global Style',
                'options'     => array(
                  'header-style-one'    => 'Header Style 1',
                  'header-style-two'    => 'Header Style 2',
                  'header-style-three'  => 'Header Style 3',
                  'header-style-four'  => 'Header Style 4',
                ),
                'default'     => 'header-style-one'
            ),
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header One Option', 'constim-tools' ) . '</h3>',
            ),
            
            array(
                'id'    => 'call_title',
                'type'  => 'text',
                'title' => esc_html__( 'Call Title', 'constim-tools' ),
            ),

            array(
                'id'    => 'phone_no',
                'type'  => 'link',
                'title' => esc_html__( 'Phone', 'constim-tools' ),
            ),
            array(
                'id'    => 'chat_icon',
                'type'  => 'media',
                'title' => esc_html__( 'Call Icon', 'constim-tools' ),
            ),
            array(
                'id'    => 'header_1_btn',
                'type'  => 'link',
                'title' => esc_html__( 'Header One Button', 'constim-tools' ),
            ),
            array(
                'id'      => 'hd_search_icon_hidde',
                'title'   => esc_html__( 'Search Icon Disable?', 'constim-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Search Icon', 'constim-tools' ),
                'default' => true,
            ),
            array(
                'id'    => 'h_contact_title',
                'type'  => 'text',
                'title' => esc_html__( 'Contact Title', 'constim-tools' ),
            ),
            array(
                'id'    => 'h_contact_info',
                'type'  => 'text',
                'title' => esc_html__( 'Contact Info', 'constim-tools' ),
            ),
            array(
                'id'    => 'h_email_id',
                'type'  => 'link',
                'title' => esc_html__( 'Email', 'constim-tools' ),
            ),
            array(
                'id'    => 'h_login',
                'type'  => 'link',
                'title' => esc_html__( 'Login', 'constim-tools' ),
            ),

            array(
	            'type'    => 'subheading',
	            'content' => '<h3>' . esc_html__( 'Header Four Option', 'constim-tools' ) . '</h3>',
            ),
            array(
	            'id'      => 'search_icon_switcher_v4',
	            'title'   => esc_html__( 'Search Icon Switcher', 'constim-tools' ),
	            'type'    => 'switcher',
	            'desc'    => esc_html__( 'Enable or Disable Search Icon', 'constim-tools' ),
	            'default' => true,
            ),
            array(
	            'id'    => 'header_button_v4',
	            'type'  => 'link',
	            'title' => esc_html__( 'Header Four Button', 'constim-tools' ),
            ),
        ),
    ) );

    // Preloader section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Site Preloader',
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-refresh',
        'fields' => array(

            array(
                'id'      => 'preloader_enable',
                'title'   => esc_html__( 'Enable Preloader', 'constim-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Preloader', 'constim-tools' ),
                'default' => true,
            ),
            
            array(
                'id'      => 'preloader__img',
                'type'    => 'media',
                'title'   => 'Media',
                'library' => 'image',
                'output'      => '.preloader',
                'dependency'  => [
                    'preloader_enable', '==', 'true',
                ],
            ),
            

        ),
    ) );

    // Sidebar Option
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'OffCanvas Menu',
        'icon'   => 'fa fa-bars',
        'fields' => array(
            array(
                'id'      => 'is_enable_offcanvas_nav',
                'type'    => 'switcher',
                'title'   => 'Switcher',
                'label'    => esc_html__( 'Do you want Offcanvas Nav? ', 'constim-tools' ),
                'default' => true
            ),

            array(
                'id'         => 'contact_info_items',
                'type'       => 'group',
                'title'      => 'Add Contact Info',
                'fields'     => array(
                    array(
                        'id'    => 'title',
                        'type'  => 'text',
                        'title' => esc_html__( 'Title', 'constim-tools' ),
                    ),
                    array(
                        'id'    => 'icons',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icon', 'constim-tools' ),
                    ),
                    
                    array(
                        'id'    => 'infos',
                        'type'  => 'wp_editor',
                        'title' => esc_html__( 'Description', 'constim-tools' ),
                    ),
                ),
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],

            ),
            array(
                'id'         => 'offc_social_icons',
                'type'       => 'group',
                'title'      => 'Add Social Icon',
                'fields'     => array(
                    array(
                        'id'    => 'icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Social Icon', 'constim-tools' ),
                    ),
                    array(
                        'id'    => 'link',
                        'type'  => 'text',
                        'title' => esc_html__( 'Social Profile Link', 'constim-tools' ),
                    ),
                ),
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],

            ),

        ),
    ) );
    

    /*-------------------------------------
     ** Typography Options
    -------------------------------------*/
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Typography', 'constim-tools' ),
        'id'     => 'typography_options',
        'icon'   => 'fa fa-font',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Body', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'body-typography',
                'type'   => 'typography',
                'output' => 'body',

            ),

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Heading', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'heading-gl-typo',
                'type'   => 'typography',
                'output' => 'h1, h2, h3, h4, h5, h6',
            ),

        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Blog', 'constim-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Blog Options', 'constim-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Blog Breadcrumb Title', 'constim-tools'),
                'desc'    => esc_html__('If you Do not Blog Breadcrumb Custom Title then type Title Here', 'constim-tools'),
            ),
            array(
                'id'      => 'blog_breadcrumb_bg',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'constim-tools'),
            ),
            array(
                'id'      => 'blog_breadcrumb_logo',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Logo', 'constim-tools'),
            ),

            
            array(
                'id'      => 'blog_btn_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Read More Button', 'constim-tools' ),
                'default' => esc_html__( 'Explore More', 'constim-tools' ),
                'desc'    => esc_html__( 'Type Blog Read More Button Text Here', 'constim-tools' ),
            ),
        ),
    ) );
    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Single Blog', 'constim-tools' ),
        'id'     => 'single_blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Single Blog Options', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'single_breadcrumb_bg',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb BG', 'constim-tools'),
            ),
            array(
                'id'      => 'single_breadcrumb_logo',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Logo', 'constim-tools'),
            ),
            
        ),
    ) );
    
   // constim Color Setting
   CSF::createSection( $prefix . '_theme_options', array(
    'title'  => 'Color Control',
    'id'     => 'apix_color_control',
    'icon'   => 'fa fa-paint-brush',
    'fields' => array(
        
        array(  //nav bar one start
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Constim Color', 'constim-tools' ) . '</h3>',
        ),

        array(
            'id'          => 'constim_color_1',
            'type'        => 'color',
            'title'       => 'Primery Color',
            'default' => '#F94E41'
        ),

        array(
            'id'          => 'constim_color_2',
            'type'        => 'color',
            'title'       => 'Secondry Color',
            'default' => '#FE392A'
        ),
        
        array(
            'id'          => 'constim_color_3',
            'type'        => 'color',
            'title'       => 'Third Color',
            'default' => '#ffb820'
        ),
        
    ),
    ) );

    // Create a section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Error Page',
        'id'     => 'error_page',
        'icon'   => 'fa fa-exclamation-triangle',
        'fields' => array(
            

            array(  //nav bar one start
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( '404 Page Options', 'constim-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'error_code',
                'type'    => 'text',
                'title'   => esc_html__( 'Error Code', 'constim-tools' ),
                'default' => esc_html__( '404', 'constim-tools' ),
            ),
            array(
                'id'      => 'error_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Title', 'constim-tools' ),
                'default' => esc_html__( 'Oops... It looks like you ‘re lost !', 'constim-tools' ),
            ),
            array(
                'id'      => 'error_info_title',
                'type'    => 'textarea',
                'title'   => esc_html__( '404 Text', 'constim-tools' ),
                'default' => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'constim-tools' ),
            ),
            array(
                'id'      => 'error_button',
                'type'    => 'text',
                'title'   => esc_html__( '404 Button', 'constim-tools' ),
                'default' => esc_html__( 'Go Back Home', 'constim-tools' ),
            ),
            array(
                'id'      => 'er_custom_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Breadcrumb Title', 'constim-tools' ),
            ),

                     
        ),
    ) );

    /*-------------------------------------------------------
     ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer', 'constim-tools' ),
        'id'     => 'footer_options',
        'icon'   => 'fa fa-copyright',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Style Options', 'constim-tools' ) . '</h3>',
            ),
            array(
                'id'          => 'footer_glob_style',
                'type'        => 'select',
                'title'       => 'Choose Footer',
                'chosen'      => true,
                'placeholder' => 'Footer Global Style',
                'options'     => array(
	                'footer-style-one'   => 'Footer Style 1',
	                'footer-style-two'   => 'Footer Style 2',
	                'footer-style-three' => 'Footer Style 3',
                ),
                'default'     => 'footer-style-one'
            ),
            array(
                'id'      => 'footer_content_enable',
                'title'   => esc_html__( 'Footer Content Enable', 'constim-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Search Icon', 'constim-tools' ),
                'default' => true,
            ),
            array(
                'id'      => 'footer_theme_logo',
                'title'   => esc_html__( 'Main Footer Logo', 'constim-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Your Main Footer Logo Here', 'constim-tools' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Gallery Options', 'constim-tools' ) . '</h3>',
            ),
            array(
                'id'          => 'footer-gallery',
                'type'        => 'gallery',
                'title'       => 'Gallery',
                'add_title'   => 'Add Images',
                'edit_title'  => 'Edit Images',
                'clear_title' => 'Remove Images',
            ),
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Contact Info', 'constim-tools' ) . '</h3>',
            ),

            array(
                'id'    => 'contact_title',
                'type'  => 'text',
                'title' => esc_html__('Contact Title', 'constim-tools'),
            ),

            array(
                'id'    => 'cf_f_email',
                'type'  => 'textarea',
                'title' => esc_html__('Contact Email', 'constim-tools'),
            ),

            array(
                'id'    => 'f_newsletter_shortcode',
                'title' => esc_html__( 'Newsletter Shortcode', 'constim-tools' ),
                'type'  => 'text',
            ),
            
            array(
                'id'    => 'ft_phone_icon',
                'type'  => 'media',
                'title' => 'Upload Phone Icon',
            ),
            array(
                'id'    => 'ft_phone_title',
                'type'  => 'text',
                'title' => 'Phone Title',
            ),
            array(
                'id'    => 'ft_phone_no',
                'type'  => 'text',
                'title' => 'Phone Number',
            ),
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Menu', 'constim-tools' ) . '</h3>',
            ),
            array(
                'id'    => 'f_logo_icon',
                'type'  => 'media',
                'title' => 'Logo Icon',
            ),
            array(
                'id'          => 'footer_nav',
                'type'        => 'select',
                'title'       => 'Footer Menu',
                'options'     => 'menu',
                'default'     => ''
            ),
            array(
                'id'          => 'footer_cp_nav',
                'type'        => 'select',
                'title'       => 'Footer Condition Menu',
                'options'     => 'menu',
                'default'     => ''
            ),
            array(
                'id'    => 'constim_copywrite_text',
                'title' => esc_html__( 'Copyright Area Text', 'constim-tools' ),
                'type'  => 'wp_editor',
                'desc'  => esc_html__( 'Footer Copyright Text', 'constim-tools' ),
            ),

            array(
	            'type'    => 'subheading',
	            'content' => '<h3>' . esc_html__( 'Footer Three Content', 'constim-tools'
		            ) . '</h3>',
            ),
            array(
	            'id'      => 'footer_logo_v3',
	            'title'   => esc_html__( 'Footer Logo', 'constim-tools' ),
	            'type'    => 'media',
	            'library' => 'image',
	            'desc'    => esc_html__( 'Upload Your Footer Logo Here', 'constim-tools' ),
            ),
            array(
	            'id'    => 'site_info_v3',
	            'type'  => 'textarea',
	            'title' => esc_html__('Site Info', 'constim-tools'),
	            'default' => 'A new way to make the payments easy,reliable and 100% secure. claritatem itamconse quates Exerci tation ullamcorper.'
            ),
            array(
	            'id'        => 'social_icon_group_v3',
	            'type'      => 'group',
	            'title'     => 'Social Icon',
	            'fields'    => array(
		            array(
			            'id'    => 'social_icon_v3',
			            'type'  => 'icon',
			            'title' => 'Social Icon',
		            ),
		            array(
			            'id'    => 'social_icon_link_v3',
			            'type'  => 'link',
			            'title' => 'Link',
		            ),
	            ),
            ),
            array(
	            'id'    => 'about_us_v3',
	            'type'  => 'text',
	            'title' => 'About us',
	            'default' => 'About us:'
            ),
            array(
	            'id'    => 'about_content_v3',
	            'type'  => 'textarea',
	            'title' => 'About Content',
	            'default' => 'Company offer a fully comprehensive drainage service and have over 35 years of experience within the field, you can rest assured.'
            ),
            array(
	            'id'    => 'quick_link_v3',
	            'type'  => 'text',
	            'title' => 'Quick Link',
	            'default' => 'Quick links:'
            ),
            array(
	            'id'          => 'quick_nav_v3',
	            'type'        => 'select',
	            'title'       => 'Quick Nav',
	            'options'     => 'menu',
	            'default'     => ''
            ),
            array(
	            'id'    => 'office_info_v3',
	            'type'  => 'text',
	            'title' => 'Office Info',
	            'default' => 'Official info:'
            ),
            array(
	            'id'        => 'office_info_group_v3',
	            'type'      => 'group',
	            'title'     => 'Office Info Content',
	            'fields'    => array(
		            array(
			            'id'    => 'office_info_icon_v3',
			            'type'  => 'icon',
			            'title' => 'Info Icon',
		            ),
		            array(
			            'id'    => 'office_info_text_v3',
			            'type'  => 'text',
			            'title' => 'Info Text',
		            ),
	            ),
            ),
            array(
	            'id'    => 'office_open_hour_v3',
	            'type'  => 'text',
	            'title' => 'Office Open Hour',
	            'default' => 'Open Hours:'
            ),
            array(
	            'id'    => 'office_open_hour_time_v3',
	            'type'  => 'text',
	            'title' => 'Office Open Hour Time',
	            'default' => 'Mon - Sat: 8 am - 5 pm, Sunday: CLOSED'
            ),
            array(
	            'id'    => 'copywrite_text_v3',
	            'title' => esc_html__( 'Copyright Text', 'constim-tools' ),
	            'type'  => 'wp_editor',
	            'desc'  => esc_html__( 'Footer Copyright Text', 'constim-tools' ),
            ),

        ),
    ) );

    // Backup section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Backup Export', 'constim-tools' ),
        'id'     => 'backup_options',
        'icon'   => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        ),
    ) );




}