<?php
/*
 * Theme Metabox
 * @package constim-tools
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    $prefix = 'constim';

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'constim_page_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Page Options',
        'post_type' => array('plan', 'page', 'post'),
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Header Option', 'constim-tools' ),
            ),

            array(
                'id'      => 'page_logo',
                'title'   => esc_html__( 'Page Header Logo', 'constim-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Logo Here', 'constim-tools' ),
            ),

            array(
                'id'      => 'header_layout',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Header Navigation Style', 'constim-tools' ),
                'options'     => array(
                    'disable'    => 'Select Header Style',
                    'header-style-one'    => 'Header Style 1',
                    'header-style-two'    => 'Header Style 2',
                    'header-style-three'  => 'Header Style 3',
                    'header-style-four'  => 'Header Style 4',
                ),
                'default' => '',
            ),
            
            array(
                'id'      => 'ap_custom_menu',
                'type'    => 'checkbox',
                'title'   => 'Onepage Menu',
                'label'   => 'If You Want to Display Onepage Menu Then click to check the box',
                'default' => false // or false
            ),

        ),
    ) );

    // Breadcrumb Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Breadcrumb',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Breadcrumb Option', 'constim-tools' ),
            ),
            array(
                'id'      => 'is_active_breadcrumb',
                'type'    => 'switcher',
                'title'   => 'Switcher',
                'label'    => esc_html__( 'Do you want activate Breadcrumb ?', 'constim-tools' ),
                'default' => true
            ),
            array(
                'id'      => 'br_bg',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Background', 'constim-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            array(
                'id'      => 'br_meta_logo',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Logo', 'constim-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Custom Title', 'constim-tools'),
                'desc'    => esc_html__('If you Do not Show Page Title thene type Custom Title Here', 'constim-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            
        )
    ) );
    

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Footer',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Option', 'constim-tools' ),
            ),

            array(
                'id'      => 'footer_layout',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Footer Style', 'constim-tools' ),
                'options'     => array(
                    'disable'            => 'Select Footer',
                    'footer-style-one'   => 'Footer Style 1',
                    'footer-style-two'   => 'Footer Style 2',
                    'footer-style-three' => 'Footer Style 3',
                ),
                'default' => 'disable',
            ),
            array(
                'id'      => 'page_footer_logo',
                'title'   => esc_html__( 'Page Footer Logo', 'constim-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Logo Here', 'constim-tools' ),
            ),
            

        ),
    ) );

     /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'constim_pricing_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Pricing Options',
        'post_type' => 'constim_pricing',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'constim Pricing Table ',
        'fields' => array(
            array(
                'id'      => 'populer_item',
                'type'    => 'checkbox',
                'title'   => 'Select Populer Item',
                'label'   => 'If you want to Populer Item then please check the box',
                'default' => false // or false
            ),
            array(
                'id'    => 'offer_text',
                'type'  => 'text',
                'title' => esc_html__( 'Offer Text', 'constim-tools' ),
            ),
            array(
                'id'    => 'currency',
                'type'  => 'text',
                'title' => esc_html__( 'Currency', 'constim-tools' ),
                'default' => '$',
            ),
            array(
                'id'    => 'monthly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Price ', 'constim-tools' ),
            ),
            array(
                'id'    => 'yearly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Price ', 'constim-tools' ),
            ),
            array(
                'id'    => 'mon_period',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Period ', 'constim-tools' ),
                'default' => esc_html__( '/ Monthly', 'constim-tools' ),
            ),
            array(
                'id'    => 'yr_period',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Period ', 'constim-tools' ),
                'default' => esc_html__( '/ Yearly', 'constim-tools' ),
            ),
            array(
                'id'         => 'pricing_lists',
                'type'       => 'group',
                'title'      => 'Add Pricing List Item',
                'fields'     => array(
                    
                    array(
                        'id'    => 'list-item',
                        'type'  => 'text',
                        'title' => esc_html__( 'Pricing List Item', 'constim-tools' ),
                    ),
                    array(
                        'id'      => 'exclude-in-package',
                        'title'   => esc_html__( 'Exclude In This Package', 'constim-tools' ),
                        'type'    => 'switcher',
                        'default' => false,
                    ),
                )

            ),
            array(
                'id'    => 'pricing_btn',
                'type'  => 'link',
                'title' => esc_html__( 'Pricing Button', 'constim-tools' ),
            ),
            array(
                'id'    => 'pricing_txt',
                'type'  => 'text',
                'title' => esc_html__( 'Pricing Text', 'constim-tools' ),
            ),

        ),
    ) );

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'constim_service_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Service Options',
        'post_type' => 'service',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Constim Service ',
        'fields' => array(
            
            array(
                'id'    => 'service_img_icon',
                'type'  => 'media',
                'title' => esc_html__( 'Service Icon Image', 'constim-tools' ),
            ),
            array(
                'id'          => 'service-style',
                'type'        => 'select',
                'title'       => 'Select',
                'options'     => array(
                  'style-one'  => 'Style One',
                  'style-two'  => 'Style Two',
                ),
              ),
              array(
                'id'    => 'sub_cate_name',
                'type'  => 'TEXT',
                'title' => esc_html__( 'Sub Title Name', 'constim-tools' ),
            ),
        ),
    ) );


    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $cate_metabox = 'constim_cate_meta';

    CSF::createTaxonomyOptions( $cate_metabox, array(
        'taxonomy'  => 'category',
        'data_type' => 'serialize',
    ) );

     // Header Section
     CSF::createSection( $cate_metabox, array(
        'title'  => 'Category Icon',
        'fields' => array(
            array(
                'id'      => 'icon_name',
                'type'    => 'text',
                'title'   => 'Type Icon Name',
            ),
        ),
    ) );


    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_format_metabox = 'constim_post_format_meta';

    CSF::createMetabox( $post_format_metabox, array(
        'title'     => 'Post Video',
        'post_type' => 'post',
		'post_formats' => 'video',
		'data_type'          => 'serialize',
		'context'            => 'advanced',
		'priority'           => 'default',
    ) );

     // Header Section
     CSF::createSection( $post_format_metabox, array(
        'title'  => 'Category Icon',
        'fields' => array(
            array(
                'id'      => 'video_link',
                'type'    => 'text',
                'title'   => esc_html__('Video Link', 'constim-tools'),
                'desc'    => esc_html__('Enter Video Link Here', 'constim-tools'),
            ),
        ),
    ) );


    
    

} //endif
