<?php

/**
 * All Category List
 */
function constim_blog_category (){
  $terms = get_terms( array(
      'taxonomy'    => 'category',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->slug]  = [$post->name];
  }
  return $cat_list;
}


function constim_service_category() {
	$options = array();
	$taxonomy = 'services_cate';
	if (!empty($taxonomy)) {
		$terms = get_terms(
				array(
					'parent' => 0,
					'taxonomy' => $taxonomy,
					'hide_empty' => false,
				)
		);
		if (!empty($terms)) {
			foreach ($terms as $term) {
				if (isset($term)) {
					$options[''] = 'Select';
					if (isset($term->slug) && isset($term->name)) {
						$options[$term->slug] = $term->name;
					}
				}
			}
		}
	}
	return $options;
}


function constim_post_category (){
  $terms = get_terms( array(
      'taxonomy'    => 'projects_cate',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->slug]  = [$post->name];
  }
  return $cat_list;
}

function constim_project_slug (){
  $terms = get_terms( array(
      'taxonomy'    => 'projects_cate',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->term_id]  = [$post->name];
  }
  return $cat_list;
}

/**
 * Tag List
 */
if ( ! function_exists( 'constim_item_tag_lists' ) ) {
  function constim_item_tag_lists(  $type = '', $query_args = array() ) {

    $options = array();

    switch( $type ) {

      case 'pages':
      case 'page':
      $pages = get_pages( $query_args );

      if ( !empty($pages) ) {
        foreach ( $pages as $page ) {
          $options[$page->post_title] = $page->ID;
        }
      }
      break;

      case 'posts':
      case 'post':
      $posts = get_posts( $query_args );

      if ( !empty($posts) ) {
        foreach ( $posts as $post ) {
          $options[$post->post_title] = lcfirst($post->ID);
        }
      }
      break;

      case 'tags':
      case 'tag':

      if (isset($query_args['taxonomies']) && taxonomy_exists($query_args['taxonomies'])) {
        $tags = get_terms( $query_args['taxonomies'] );
          if ( !is_wp_error($tags) && !empty($tags) ) {
            foreach ( $tags as $tag ) {
              $options[$tag->name] = $tag->term_id;
          }
        }
      }
      break;
    }

    return $options;

  }
}

/**
 * Post Time Ago
 */
function constim_ready_time_ago(){
  return human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) );
}

function constim_category_pl(){
  $catgorys = get_the_category();
  foreach( $catgorys as $key => $category):
      ?>
      <a class="cat" href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
        <?php echo esc_html($category->cat_name); ?>
      </a>
  <?php endforeach;
}

function constim_menu_selector() {
  $menus = wp_get_nav_menus();
  $items = array();
  $i     = 0;
  foreach ( $menus as $menu ) {
      if ( $i == 0 ) {
          $default = $menu->slug;
          $i ++;
      }
      $items[ $menu->slug ] = $menu->name;
  }
  return $items;
}


/**
 * Post Social Share
 *
 * @return void
 */
function constim_post_share() {

  $permalink = get_permalink( get_the_ID() );
  $title     = get_the_title();
?>
<ul class="social-box">
  <span class="share"><?php esc_html_e( 'Share:', 'constim-tools' );?></span>
  <li><a class="fb" onClick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>"><?php esc_html_e( 'facebook', 'constim-tools' );?></a></li>

  <li><a class="tw" onClick="window.open('http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><?php esc_html_e( 'twitter', 'constim-tools' );?></a></li>

  <li><a class="ln" onClick="window.open('https://www.linkedin.com/cws/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Linkedin share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><?php esc_html_e( 'linkedin', 'constim-tools' );?></a></li>

  <li><a class="pt" href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'><?php esc_html_e( 'pinterest', 'constim-tools' );?></a></li>

</ul>
<?php 
}

/**
 * Post Social Share
 *
 * @return void
 */
function constim_single_post_share() {

  $permalink = get_permalink( get_the_ID() );
  $title     = get_the_title();
?>
  <ul class="social-box">
    <span class="share"><?php esc_html_e( 'Share:', 'constim-tools' );?></span>
    <li><a class="fb" onClick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>"><i class="fab fa-facebook-f"></i></a></li>

    <li><a class="tw" onClick="window.open('http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><i class="fab fa-twitter"></i></a></li>

    <li><a class="ln" onClick="window.open('https://www.linkedin.com/cws/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Linkedin share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><i class="fab fa-linkedin-in"></i></a></li>

    <li><a class="pt" href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'><i class="fab fa-pinterest-p"></i></a></li>

  </ul>
<?php 
}



/**
 * Get Menu List
 *
 * @return void
 */
function constim_get_nav_menu(){

  $menus = array(
      '' => esc_html__('Default', 'constim')
  );

  $obj_menus = wp_get_nav_menus();

  foreach ($obj_menus as $obj_menu){
      $menus[$obj_menu->term_id] = $obj_menu->name;
  }

  return $menus;
}


/**
 * Add Contact Method User
 */
function constim_user_social_link( $methode ) {
    $methode['facebook']  = esc_html__( 'Facebook', 'constim-tools' );
    $methode['twitter']   = esc_html__( 'Twitter', 'constim-tools' );
    $methode['linkedin']  = esc_html__( 'Linkedin', 'constim-tools' );
    $methode['instagram'] = esc_html__( 'Instagram', 'constim-tools' );
    $methode['pinterest'] = esc_html__( 'Pinterest', 'constim-tools' );
    $methode['youtube']   = esc_html__( 'YouTube', 'constim-tools' );
  return $methode;
}
add_filter('user_contactmethods', 'constim_user_social_link');


/**
 * Authore
 */
function constim_authore_info() {
  
  global $post;
  if(is_object($post)):

  $theme_author_markup = '';
  // Get author's display name
  $display_name = get_the_author_meta( 'display_name', $post->post_author );

  // If display name is not available then use nickname as display name
  if ( empty( $display_name ) )
  $display_name = get_the_author_meta( 'nickname', $post->post_author );

  // Get author's biographical information or description
  $user_description   = get_the_author_meta( 'user_description', $post->post_author );
  
  $user_facebook      = get_the_author_meta('facebook', $post->post_author);
  $user_twitter       = get_the_author_meta('twitter', $post->post_author);
  $user_linkedin      = get_the_author_meta('linkedin', $post->post_author);
  $user_instagram     = get_the_author_meta('instagram', $post->post_author);
  $user_pinterest     = get_the_author_meta('pinterest', $post->post_author);
  $user_youtube       = get_the_author_meta('youtube', $post->post_author);

  // Get link to the author archive page
  $user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
  if ( ! empty( $display_name ) )
  // Author avatar - - the number 90 is the px size of the image.
  $theme_author_markup .= '<div class="thumb">' . get_avatar( get_the_author_meta('ID') , 156 ) . '</div>';
  $theme_author_markup .= '<div class="name">' . $display_name . '</div>';
  
  $theme_author_markup .= '<div class="text">';
  $theme_author_markup .= '<p>' . get_the_author_meta( 'description' ). '</p>';
  $theme_author_markup .= '</div>';
  $theme_author_markup .= '<ul class="social-box">';


// Check if author has Twitter in their profile

  if ( ! empty( $user_facebook ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_facebook .'" target="_blank" rel="nofollow" class="fb_aut" title="Facebook"><i class="fab fa-facebook-f"></i> </a></li>';
  }

    
  if ( ! empty( $user_twitter ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_twitter .'" target="_blank" rel="nofollow" class="twi_aut" title="Twitter"><i class="fab fa-twitter"></i> </a></li>';
  }

if ( ! empty( $user_instagram ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_instagram .'" target="_blank" rel="nofollow" class="inst_aut" title="Instagram"><i class="fab fa-instagram"></i> </a></li>';
  }

if ( ! empty( $user_pinterest ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_pinterest .'" target="_blank" rel="nofollow" class="pint_aut" title="Pinterest"><i class="fab fa-pinterest-p"></i> </a></li>';
  }

  if ( ! empty( $user_youtube ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_youtube .'" target="_blank" rel="nofollow" class="you_aut" title="Youtube"><i class="fab fa-youtube"></i> </a></li>';
  }

  if ( ! empty( $user_linkedin ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_linkedin .'" target="_blank" rel="nofollow" class="link_aut" title="linkedin"><i class="fab fa-linkedin-in"></i> </a></li>';
  }

  $theme_author_markup .= '</ul>';

  // Pass all this info to post content 
  echo '<div class="blog-author-box"><div class="author-inner">' . $theme_author_markup . '</div></div>';
endif;
}


/**
 * Authore Avater
 */
function constim_post_author_avatars($size) {
  echo get_avatar(get_the_author_meta('email'), $size);
}

add_action('genesis_entry_header', 'constim_post_author_avatars');