<?php

/**
 * Domain Check
 *
 * @package constim
 * @author ThemeXriver
 * @link https://themexriver.com
 */
class constim_Domain_Check{
    

    /**
     * Constructor.
     */
    public function __construct(){
        add_action('wp_ajax_nopriv_constim_ajax_search_domain', array($this, 'ajax_search_domain'));
        add_action('wp_ajax_constim_ajax_search_domain', array($this, 'ajax_search_domain'));
        add_action('wp_head', array($this, 'domain_js_file'));
        add_action('wdes_domain_verify_code', array($this, 'verify_code'));

    }

    /**
     * Admin ajax for domain.
     */
    function domain_js_file(){
        echo '<script>
            /*<![CDATA[*/
            var constim_ajax_url = "' . admin_url('admin-ajax.php') . '";
            /*]]>*/
          </script>';
    }

    /**
     * Connect from whois server.
     *
     * @param string $domain the full domain that will checking.
     *
     * @return mixed|string
     */
    public function get_whois_server($domain)
    {

        $fp = stream_socket_client('whois.iana.org:43', $errno, $errstr, 30);
        if (!$fp) {
            echo "$errstr ($errno)<br />\n";
        } else {

            fputs($fp, $domain . "\r\n");
            $response_text = '';

            while (!feof($fp)) {
                $response_text .= fgets($fp, 128);
            }

            $response_server = '';

            if (strpos($response_text, 'but this server does not have') == 0) {
                if (strpos($domain, 'earth') == true) {
                    return $response_server = 'whois.nimzo98.com';
                }

                $split_whois = explode('whois: ', $response_text);
                $split_status = explode('status:', $split_whois[1]);
                $response_server = preg_replace('/\s+/', '', $split_status[0]);
            }


            return $response_server;
        }
    }

    /**
     * Check if domain is available.
     *
     * @param $whois_server
     * @param $domain
     *
     * @return array
     */
    public function check_available($whois_server, $domain)
    {
        if ($whois_server && $domain) {

            $fp = stream_socket_client($whois_server . ':43', $errno, $errstr, 30);
            if (!$fp) {
                echo "$errstr ($errno)<br />\n";
            } else {
                fputs($fp, $domain . "\r\n");
                $response = '';

                while (!feof($fp)) {
                    $response .= fgets($fp, 128);
                }

                //Fix for work with country extension
                $lowercase_response = strtolower($response);

                if (is_int(strpos($lowercase_response, 'domain name:'))) {
                    $result = true;
                } else {
                    $result = false;
                }

                return array(
                    'status' => $result,
                );
            }
        } else {
            return array(
                'status' => false,
            );
        }

    }

    /**
     * Get the domain result by ajax.
     */
    public function ajax_search_domain()
    {
        $domain = sanitize_text_field($_POST['domain']);
        $wmhcs_url = sanitize_text_field($_POST['whmcs_url']);



        $test = explode('.', $domain);

        if (is_array($test)) {
            if (!isset($test[1])) {
                $ext = '.com';
            } elseif ($test[0] === 'www') {
                $ext = $test[2];
                $n_domain = $test[1] . '.' . $test[2];
            } else {
                $ext = $test[1];
                $n_domain = $test[0] . '.' . $test[1];
            }
        }

        $suggestion = explode('.', $domain);
        $output = array(
            'status' => '',
            'domain' => '',
            'results_html' => '',
        );

        $whios_server = $this->get_whois_server($domain);



        if (empty($whios_server)) {

            $output = array(
                'status' => 'no_support',
                'domain' => $domain,
                'results_html' => esc_html__('Please check the domain name or extension', 'constim-core'),
            );

        } else {

            $whois_server = $whios_server;
            $output = $this->check_available($whois_server, $domain);

            $output['status'] = ($output['status']) ? 'taken' : 'available';
            $output['domain'] = $domain;

            // result html.
            if ($output['status'] === 'available') {
                $output['results_html'] .= '<input type="hidden" name="domain" placeholder="' . esc_attr__('eg: example.com', 'constim-core') . '" autocapitalize="none" value="'. $domain . '">';
                $output['results_html'] .= '<div class="result-wrapper alert alert-success"><i class="far fa-check-circle"></i>'.esc_html('Congratulation', 'qhost-core').' <span class="available">'.$domain.' </span>' . esc_html__('is available!', 'constim-core') . '<span class="reasult-info"><a href="' . $wmhcs_url . $domain . '" class="constim-btn" target="_blank"><input type="button" class="wdes-purchase-btn template-btn primary-btn btn-small flex-shrink-0 border-0" value="' . esc_attr__('Purchase', 'constim-core') . '"></a></span></div>';
            } else {
                $output['results_html'] .= '<div class="result-wrapper alert alert-danger"><span class="constim-btn-token"><i class="fas fa-exclamation-circle icon-taken"></i><span class="available">'.$domain.' </span>' .' ' . esc_html__('is unavailable', 'constim-core') . '</span>';
            }
        }

        wp_send_json($output);
    }

    /**
     * Verify code
     */
    public function verify_code(){
        echo '<input type="hidden" name="token" value="0811bf819565bf8142cc613d099e85a27ec1204c">';
    }


}

$obj = new constim_Domain_Check();