<?php

/**
 * Service Csutom Post
 */

if ( !function_exists( 'service' ) ) {

    // Register service
    function service() {

        $labels = array(
            'name'                  => esc_html_x( 'Services', 'Post Type General Name', 'constim-tools' ),
            'singular_name'         => esc_html_x( 'Service', 'Post Type Singular Name', 'constim-tools' ),
            'menu_name'             => esc_html__( 'Service', 'constim-tools' ),
            'name_admin_bar'        => esc_html__( 'Service', 'constim-tools' ),
            'archives'              => esc_html__( 'Item Archives', 'constim-tools' ),
            'attributes'            => esc_html__( 'Item Attributes', 'constim-tools' ),
            'parent_item_colon'     => esc_html__( 'Parent Item:', 'constim-tools' ),
            'all_items'             => esc_html__( 'All services', 'constim-tools' ),
            'add_new_item'          => esc_html__( 'Add New service', 'constim-tools' ),
            'add_new'               => esc_html__( 'Add New service', 'constim-tools' ),
            'new_item'              => esc_html__( 'New service', 'constim-tools' ),
            'edit_item'             => esc_html__( 'Edit service', 'constim-tools' ),
            'update_item'           => esc_html__( 'Update service', 'constim-tools' ),
            'view_item'             => esc_html__( 'View service', 'constim-tools' ),
            'view_items'            => esc_html__( 'View service', 'constim-tools' ),
            'search_items'          => esc_html__( 'Search service', 'constim-tools' ),
            'not_found'             => esc_html__( 'Not found', 'constim-tools' ),
            'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'constim-tools' ),
            'featured_image'        => esc_html__( 'Featured Image', 'constim-tools' ),
            'set_featured_image'    => esc_html__( 'Set featured image', 'constim-tools' ),
            'remove_featured_image' => esc_html__( 'Remove featured image', 'constim-tools' ),
            'use_featured_image'    => esc_html__( 'Use as featured image', 'constim-tools' ),
            'insert_into_item'      => esc_html__( 'Insert into item', 'constim-tools' ),
            'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'constim-tools' ),
            'items_list'            => esc_html__( 'Items list', 'constim-tools' ),
            'items_list_navigation' => esc_html__( 'Items list navigation', 'constim-tools' ),
            'filter_items_list'     => esc_html__( 'Filter items list', 'constim-tools' ),
        );
        $args = array(
            'label'               => esc_html__( 'Services', 'constim-tools' ),
            'description'         => esc_html__( 'Add Service Here', 'constim-tools' ),
            'labels'              => $labels,
            'supports'            => array( 'title', 'excerpt', 'thumbnail', 'editor', 'elementor' ),
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'rewrite' => array( 
                'slug' => 'service', // use this slug instead of post type name
                'with_front' => FALSE // if you have a permalink base such as /blog/ then setting this to false ensures your custom post type permalink structure will be /products/ instead of /blog/products/
            ),
            'show_in_menu'        => true,
            'menu_position'       => 5,
            'menu_icon'           => 'dashicons-align-left',
            'show_in_admin_bar'   => true,
            'show_in_nav_menus'   => true,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
        );
        register_post_type( 'service', $args );

    }
    add_action( 'init', 'service', 0 );

}


/**
 * Service Custom Taxonomy
 */

 if ( !function_exists( 'services_cate_taxonomy' ) ) {
    function services_cate_taxonomy() {
        $labels = [
            'name'          => esc_html__( 'Service Categories', 'constim-tools' ),
            'menu_name'     => esc_html__( 'Service Categories', 'constim-tools' ),
            'singular_name' => esc_html__( 'Service Category', 'constim-tools' ),
            'search_items'  => esc_html__( 'Search Service Category', 'constim-tools' ),
            'all_items'     => esc_html__( 'All Service Category', 'constim-tools' ),
            'new_item_name' => esc_html__( 'New Service Category', 'constim-tools' ),
            'add_new_item'  => esc_html__( 'Add New Service Category', 'constim-tools' ),
            'edit_item'     => esc_html__( 'Edit New Service Category', 'constim-tools' ),
            'update_item'   => esc_html__( 'Update New Service Category', 'constim-tools' ),
        ];
        $args = array(
            'labels'                => $labels,
            'hierarchical'          => true,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'update_count_callback' => '_update_post_term_count',
            'rewrite'               => array( 'slug' => 'Service-category' ),
        );
        register_taxonomy( 'services_cate', 'service', $args );
    }
    add_action( 'init', 'services_cate_taxonomy' );
}