<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Works_Tabs extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-work-tabs-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Works Tabs', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'constim-tools' ),
				'label_off' => esc_html__( 'NO', 'constim-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Work Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'text', [
				'label' => esc_html__( 'Work Text', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'work_img', [
				'label' => esc_html__( 'Work Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		
		$repeater->add_control(
			'project_count', [
				'label' => esc_html__( 'Project Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_title', [
				'label' => esc_html__( 'Project Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        
		$this->add_control(
			'works_tabs',
			[
				'label' => esc_html__( 'Add Works Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="industry-section" style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)">
        <div class="auto-container">
            <!-- Industry Info Tabs -->
            <div class="industry-info-tabs">
                <!-- industry Tabs -->
                <div class="industry-tabs tabs-box clearfix">
                    <div class="row clearfix">
                        <!-- Left Column -->
                        <div class="buttons-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <!-- Tab Btns -->
                                <ul class="tab-btns tab-buttons clearfix">
                                    <?php foreach($settings['works_tabs'] as $item):?>
                                        <li data-tab="#prod-one<?php echo esc_attr($item['_id']);?>" class="tab-btn  <?php if($item['is_active'] == 'yes'){ echo esc_attr('active-btn');}?>"><strong><?php echo wp_kses( $item['title'], true )?></strong> <span><?php echo wp_kses( $item['text'], true )?></span></li>
                                    <?php endforeach;?>
                                </ul>
                            </div>
                        </div>
                        
                        <!-- Info Column -->
                        <div class="info-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <!-- Tabs Container -->
                                <div class="tabs-content">
                                    
                                    <!-- Tab / Active Tab -->
                                    <?php foreach($settings['works_tabs'] as $item):?>
                                    <div class="tab <?php if($item['is_active'] == 'yes'){ echo esc_attr('active-tab');}?>" id="prod-one<?php echo esc_attr($item['_id']);?>">
                                        <!-- Upper Box -->
                                        <div class="upper-box d-flex align-items-center flex-wrap">
                                            <!-- Counter -->
                                            <div class="counter"><span class="odometer" data-count="250"></span>+</div>
                                            <!-- Industry Work -->
                                            <?php if(!empty($item['button_label'])):?>
                                            <a class="industry-work" href="<?php echo esc_url($settings['button_link']['url']);?>"><?php echo esc_html($item['button_label']);?></a>
                                            <?php endif;?>
                                        </div>
                                        <!-- Lower Box -->
                                        <?php if(!empty($item['work_img']['url'])):?>
                                        <div class="lower-box">
                                            <div class="image">
                                                <img src="<?php echo esc_url($item['work_img']['url']);?>" alt="" />
                                            </div>
                                        </div>
                                        <?php endif;?>
                                    </div>
                                    <?php endforeach;?>
                                    
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Works_Tabs() );