<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class why_choose_us extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'why-choose-us';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Why Choose Us', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Why Choose Us', true)
            ]
        );

		$this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Many Reasons For People Choosing us', true)
            ]
        );

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'progress_title',
			[
				'label' => esc_html__('Progress Title', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Maintenance', true)
			]
		);

		$repeater->add_control(
			'progress_number',
			[
				'label' => esc_html__('Progress Number', 'thepack'),
				'type' => Controls_Manager::NUMBER,
				'label_block' => true,
				'default' => 95
			]
		);

		$this->add_control(
            'progress',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
                'default' => [
	                [
		                'progress_title' => esc_html__( 'Maintenance', 'textdomain' ),
	                ],
	                [
		                'progress_title' => esc_html__( 'REPAIRING & TESTING', 'textdomain' ),
	                ],
	                [
		                'progress_title' => esc_html__( 'WIRING & INSTALLATION', 'textdomain' ),
	                ],
	                [
		                'progress_title' => esc_html__( 'WIRING & INSTALLATION', 'textdomain' ),
	                ],
                ],
                'title_field' => '{{{ progress_title }}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'why_choose_feature_content',
			[
				'label' => __( 'Feature Content', 'appilo' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'box_img',
			[
				'label' => esc_html__( 'Feature Icon Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'box_title',
			[
				'label' => esc_html__('Feature Title', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Quality Materials', true)
			]
		);
		$repeater->add_control(
			'box_info',
			[
				'label' => esc_html__('Feature Info', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('We pride ourselves on giving our clients a professional and reliable customer.', true)
			]
		);

		$this->add_control(
			'choose_box',
			[
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'box_title' => esc_html__( 'Quality Materials', 'textdomain' ),
					],
					[
						'box_title' => esc_html__( '24/7 Services', 'textdomain' ),
					],
					[
						'box_title' => esc_html__( 'Free Estimates', 'textdomain' ),
					],
					[
						'box_title' => esc_html__( 'Professional touch', 'textdomain' ),
					],
				],
				'title_field' => '{{{ box_title }}}',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'video-play-content',
			[
				'label' => __( 'Video Content', 'appilo' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'video_bg',
			[
				'label' => esc_html__( 'Video BG Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video Link', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'textdomain' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => 'https://www.youtube.com/watch?v=kxPCFljwJws',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_bg',
			[
				'label' => esc_html__( 'Section BG Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'Section-Before-BG-Color',
			[
				'label' => esc_html__( 'Section Before BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .choose-one_image-layer:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two.light .sec-title-two_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two.light .sec-title-two_title',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two.light h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two.light h2',
			]
		);

		$this->add_control(
			'--Progress-Bar-Style--',
			[
				'label' => esc_html__( 'Progress Bar Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Progress-Bar-Color',
			[
				'label' => esc_html__( 'Progress Bar Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .default-skills.style-two .default-skill-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .default-skills.style-two .default-count-box' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Progress-Bar-Typography',
				'label' => esc_html__( 'Progress Bar Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .default-skills.style-two .default-skill-title, {{WRAPPER}} .default-skills.style-two .default-count-box',
			]
		);
		$this->add_control(
			'Active-Progress-Bar-Color',
			[
				'label' => esc_html__( 'Active Progress Bar Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .default-bar' => 'border-bottom-color: {{VALUE}}',
					'{{WRAPPER}} .default-skills.style-two .default-skill-bar' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Service_style_1',
			[
				'label' => __( 'Service Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Service-Title-Color',
			[
				'label' => esc_html__( 'Service Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .choose-one_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-Title-Typography',
				'label' => esc_html__( 'Service Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .choose-one_title',
			]
		);
		$this->add_control(
			'Service-info-Color',
			[
				'label' => esc_html__( 'Service info Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .choose-one_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-info-Typography',
				'label' => esc_html__( 'Service info Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .choose-one_text',
			]
		);

		$this->add_control(
			'--Play-Button-Style--',
			[
				'label' => esc_html__( 'Play Button Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Play-Button-BG-Color',
			[
				'label' => esc_html__( 'Play Button BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .choose-one_play-box' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();



	}


	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>

    <!-- Choose One -->
    <section class="choose-one">
        <div class="choose-one_image-layer" style="background-image:url(<?php echo esc_url($settings['section_bg']['url']) ?>)"></div>
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Skill Column -->
                <div class="choose-one_skill-column col-lg-6 col-md-12 col-sm-12">
                    <div class="choose-one_skill-column-inner">
                        <!-- Sec Title Two -->
                        <div class="sec-title-two light">
                            <div class="sec-title-two_title"><?php echo esc_html( $settings['subtitle'] ); ?></div>
                            <h2 class="sec-title-two_heading"><?php echo esc_html( $settings['title'] ); ?></h2>
                        </div>
                        <!-- Skills / Style Two -->
                        <div class="default-skills style-two">
                            <?php foreach ($settings['progress'] as $progress): ?>
                            <!-- Skill Item -->
                            <div class="default-skill-item">
                                <div class="default-skill-title"><?php echo esc_html( $progress['progress_title'] ); ?></div>
                                <div class="default-skill-bar">
                                    <div class="default-bar-inner">
                                        <div class="default-bar progress-line" data-width="<?php echo esc_attr( $progress['progress_number'] ); ?>">
                                            <div class="default-skill-percentage"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="default-count-box count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr( $progress['progress_number'] ); ?>">0</span>%</div>
                            </div>
                            <?php endforeach; ?>

                        </div>
                    </div>
                </div>
                <!-- Blocks Column -->
                <div class="choose-one_blocks-column col-lg-6 col-md-12 col-sm-12">
                    <div class="choose-one_blocks-column-inner">
                        <div class="row clearfix">
                            <?php foreach ($settings['choose_box'] as $box): ?>
                            <!-- Choose One Block -->
                            <div class="choose-one_block col-lg-6 col-md-6 col-sm-12">
                                <div class="choose-one_block-inner">
                                    <div class="choose-one_icon">
                                        <img src="<?php echo esc_url( $box['box_img']['url'] ); ?>" alt="" />
                                    </div>
                                    <h5 class="choose-one_title"><?php echo esc_html( $box['box_title'] ); ?></h5>
                                    <div class="choose-one_text"><?php echo esc_html( $box['box_info'] ); ?></div>
                                </div>
                            </div>
                            <?php endforeach; ?>

                        </div>

                        <!-- Choose Video -->
                        <div class="choose-video">
                            <img src="<?php echo esc_url( $settings['video_bg']['url'] ); ?>" alt="" />
                            <a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="lightbox-video choose-one_play-box"><img src="<?php echo get_template_directory_uri() ?>/assets/images/play-icon.png" alt="" /><i class="ripple"></i></a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Choose One -->

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new why_choose_us() );