<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Video_Popup extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-video-popup-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Video Popup', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Timeline Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'video_img', [
				'label' => esc_html__( 'Video Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'v_link', [
				'label' => esc_html__( 'Video Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="video-box">
        <figure class="video-image">
            <img class="transition-500ms" src="<?php echo esc_url($settings['video_img']['url']);?>" alt="">
        </figure>
        <a href="<?php echo esc_url($settings['v_link']['url']);?>" class="lightbox-video overlay-box"><span class="fa fa-play"><i class="ripple"></i></span></a>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Video_Popup() );