<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Testimonial extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		); 
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'authore1', [
				'label' => esc_html__( 'Authore 1', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'authore2', [
				'label' => esc_html__( 'Authore 2', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'flower', [
				'label' => esc_html__( 'Flower Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'quote', [
				'label' => esc_html__( 'Quote Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'testimonial_img', [
				'label' => esc_html__( 'Testimonial Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'authore_name', [
				'label' => esc_html__( 'Authore Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ authore_name }}}',
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .testimonial-block .content-column h2',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .content-column h2' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'd_bg',
            [
                'label' => esc_html__('Description', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'd_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .testimonial-block .content-column .text',
            ]
        );

        $this->add_control(
            'd_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .content-column .text' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="testimonial-section">
        <?php if(!empty($settings['shape']['url'])):?>
		    <div class="map-layer" style="background-image: url(<?php echo esc_url($settings['shape']['url']);?>)"></div>
        <?php endif;?>
		<!-- Author One -->
        <?php if(!empty($settings['authore1']['url'])):?>
		<div class="author-one">
			<img src="<?php echo esc_url($settings['authore1']['url']);?>" alt="" />
		</div>
        <?php endif;?>
		<!-- Author Two -->
        <?php if(!empty($settings['authore2']['url'])):?>
		<div class="author-two">
			<img src="<?php echo esc_url($settings['authore2']['url']);?>" alt="" />
		</div>
        <?php endif;?>
		<!-- Flower Icon -->
        <?php if(!empty($settings['flower']['url'])):?>
		<div class="flower-icon">
			<img src="<?php echo esc_url($settings['flower']['url']);?>" alt="" />
		</div>
        <?php endif;?>
		<div class="auto-container">
			<div class="inner-container">
				<!-- Quote Icon -->
                <?php if(!empty($settings['quote']['url'])):?>
                    <div class="quote-icon">
                        <img src="<?php echo esc_url($settings['quote']['url']);?>" alt="" />
                    </div>
                <?php endif;?>
				<div class="single-item-carousel owl-carousel owl-theme">
					
					<!-- Testimonial Block -->
                    <?php foreach($settings['testimonials'] as $item):?>
					<div class="testimonial-block">
						<div class="inner-box">
							<div class="row clearfix">
								<!-- Image Column -->
								<div class="image-column col-lg-4 col-md-12 col-sm-12">
									<div class="inner-column">
										<img src="<?php echo esc_url($item['testimonial_img']['url']);?>" alt="" />
									</div>
								</div>
								<!-- Content Column -->
								<div class="content-column col-lg-8 col-md-12 col-sm-12">
									<div class="inner-column">
										<h2><?php echo esc_html($item['authore_name']);?></h2>
										<div class="text"><?php echo wp_kses( $item['feedback'], true );?></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php endforeach;?>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Testimonial() );