<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class testimonial_v5 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonial-v5';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial V5', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('OUR SERVICES', true)
            ]
        );

		$this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Quality servicing opportunity', true)
            ]
        );

		$this->add_control(
			'info',
			[
				'label' => esc_html__('Info', 'thepack'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __('We love small plumbing jobs!!! We have plumbers on the road local to you who can complete <br> your small plumbing jobs at your convenience.', true)
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'testimonial_bg_img',
            [
                'label' => esc_html__('Testimonial BG Image', 'thepack'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true
            ]
        );

		$repeater->add_control(
			'comment',
			[
				'label' => esc_html__('Comment', 'thepack'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __('“The service has been second to none: Without exception we have found the staff to be courteous, friendly and very tidy!”', true)
			]
		);
		$repeater->add_control(
			'author_img',
			[
				'label' => esc_html__('Author Image', 'thepack'),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true
			]
		);

		$repeater->add_control(
			'name',
			[
				'label' => esc_html__('Name', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Julie Sweet', true)
			]
		);
		$repeater->add_control(
			'designation',
			[
				'label' => esc_html__('Designation', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Chair & CEO', true)
			]
		);
		$repeater->add_control(
			'ratting',
			[
				'label' => esc_html__( 'Ratting', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'step' => 1,
				'default' => 5,
			]
		);
		$this->add_control(
            'list',
            [
	            'label' => esc_html__( 'Testimonial List', 'textdomain' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
                'default' => [
	                [
		                'name' => esc_html__( 'Julie Sweet', 'textdomain' ),
	                ],
	                [
		                'name' => esc_html__( 'Julie Sweet', 'textdomain' ),
	                ],
	                [
		                'name' => esc_html__( 'Julie Sweet', 'textdomain' ),
	                ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_title',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Description-Style--',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Testimonial_style_1',
			[
				'label' => __( 'Testimonial Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Testimonial-BG-Overlay-Color',
			[
				'label' => esc_html__( 'Testimonial BG Overlay Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-five_content-inner-column:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Comment-Color',
			[
				'label' => esc_html__( 'Comment Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-five_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Comment-Typography',
				'label' => esc_html__( 'Comment Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-five_text',
			]
		);
		$this->add_control(
			'Name-Color',
			[
				'label' => esc_html__( 'Name Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-five_name' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Name-Typography',
				'label' => esc_html__( 'Name Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-five_name',
			]
		);
		$this->add_control(
			'Designation-Color',
			[
				'label' => esc_html__( 'Designation Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-five_designation' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Designation-Typography',
				'label' => esc_html__( 'Designation Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .testimonial-five_designation',
			]
		);
		$this->add_control(
			'Slider-Nav-Bg-Color',
			[
				'label' => esc_html__( 'Slider Nav Bg Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-five .owl-nav' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();



	}


	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>

    <!-- Testimonial Five -->
    <div class="testimonial-five">
        <div class="auto-container">
            <div class="sec-title-two centered">
                <div class="sec-title-two_title"><?php echo esc_html( $settings['subtitle'] ); ?></div>
                <h2 class="sec-title-two_heading"><?php echo esc_html( $settings['title'] ); ?></h2>
                <div class="sec-title-two_text"><?php echo wp_kses( $settings['info'], true ); ?></div>
            </div>
            <div class="testimonial-carousel owl-carousel owl-theme">
                <?php foreach ($settings['list'] as $item): ?>
                <!-- Testimonial Block Five -->
                <div class="testimonial-block_five">
                    <div class="row clearfix">
                        <!-- Image Column -->
                        <div class="testimonial-five_image-column col-lg-6 col-md-12 col-sm-12">
                            <div class="testimonial-five_image">
                                <img src="<?php echo esc_url( $item['testimonial_bg_img']['url'] ); ?>" alt="" />
                            </div>
                        </div>
                        <!-- Content Column -->
                        <div class="testimonial-five_content-column col-lg-6 col-md-12 col-sm-12">
                            <div class="testimonial-five_content-inner-column" style="background-image:url(<?php echo esc_url( $item['testimonial_bg_img']['url'] ); ?>)">
                                <div class="testimonial-five_rating">
                                    <?php
                                    if ($item['ratting'] == 1 ){
	                                    echo '<span class="fa fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>';
                                    } elseif ( $item[ 'ratting' ] == 2 ) {
	                                    echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>';
                                    } elseif ( $item[ 'ratting' ] == 3 ) {
	                                    echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fas fa-star"></span>
                                                <span class="fas fa-star"></span>';
                                    } elseif ( $item[ 'ratting' ] == 4 ) {
	                                    echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fas fa-star"></span>';
                                    } else {
	                                    echo '<span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>
                                                <span class="fa fa-star"></span>';
                                    }
                                    ?>
                                </div>
                                <div class="testimonial-five_text"><?php echo wp_kses($item['comment'], true); ?></div>
                                <div class="testimonial-five_info">
                                    <div class="testimonial-five_info-inner">
                                        <div class="testimonial-five_thumb">
                                            <img src="<?php echo esc_url( $item['author_img']['url'] ); ?>" alt="" />
                                        </div>
                                        <h6 class="testimonial-five_name"><?php echo esc_html( $item['name'] ); ?></h6>
                                        <div class="testimonial-five_designation"><?php echo esc_html( $item['designation'] ); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>

            </div>
        </div>
    </div>
    <!-- End Testimonial Five -->

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new testimonial_v5() );