<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Testimonial_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-v2-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial V2', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'testbackground',
				'types' => [ 'classic' ],
				'exclude' => [ 'color' ],
				'selector' => '{{WRAPPER}} .testimonial-block-three .image:before',
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'testimonial_img', [
				'label' => esc_html__( 'Testimonial Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'authore_name', [
				'label' => esc_html__( 'Authore Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ authore_name }}}',
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="testimonial-section-three">
        <div class="auto-container">
            <div class="inner-container">
                <div class="single-item-carousel owl-carousel owl-theme">
                    
                    <!-- Testimonial Block Three -->
                    <?php foreach($settings['testimonials'] as $item):?>
                    <div class="testimonial-block-three">
                        <div class="inner-box">
                            <div class="row clearfix">
                                <!-- Image Column -->
                                <div class="image-column col-lg-4 col-md-12 col-sm-12">
									<div class="inner-column">
										<div class="image">
                                            <img src="<?php echo esc_url($item['testimonial_img']['url']);?>" alt="" />
										</div>
									</div>
								</div>
                                <div class="content-column col-lg-8 col-md-12 col-sm-12">
									<div class="inner-column">
										<div class="text"><?php echo wp_kses( $item['feedback'], true );?></div>
										<div class="designation">
                                            <?php echo esc_html($item['authore_name']);?>
											<span><?php echo esc_html($item['designation']);?></span>
										</div>
									</div>
								</div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Testimonial_V2() );