<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Testimonial_Quote extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-quote-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Quote', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Quote', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'authore_img', [
				'label' => esc_html__( 'Authore Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'authore_name', [
				'label' => esc_html__( 'Authore Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'authore_signature', [
				'label' => esc_html__( 'Authore Signature', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'rating_title', [
				'label' => esc_html__( 'Rating Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'constim-tools' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 1,
			]
		);
        $repeater->add_control(
			'quote_icon', [
				'label' => esc_html__( 'Quote Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ authore_name }}}',
			]
		);
		
        $this->add_control(
			'form_title', [
				'label' => esc_html__( 'Form Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
        $this->add_control(
			'form_shortcode', [
				'label' => esc_html__( 'Form Shortcode', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="testimonial-section-two">
        <?php if(!empty($settings['shape']['url'])):?>
		    <div class="image-layer" style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)"></div>
        <?php endif;?>
		<div class="auto-container">
			<!-- Sec Title -->
			<div class="sec-title">
                <?php if(!empty($settings['bigtitle'])):?>
				    <div class="big-title title-anim"><?php echo esc_html($settings['bigtitle']);?></div>
                <?php endif;?>
                <?php if(!empty($settings['title'])):?>
				    <h2 class="title-anim"><?php echo wp_kses( $settings['title'], true )?></h2>
                <?php endif;?>
                <?php if(!empty($settings['arrow_icon']['url'])):?>
				    <div class="arrow title-anim"><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt="" /></div>
                <?php endif;?>
			</div>
			<div class="row clearfix">
				
				<!-- Carousel Column -->
				<div class="carousel-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<div class="single-item-carousel owl-carousel owl-theme">
							
							
							<!-- Testimonial Block Two -->
                            <?php foreach($settings['testimonials'] as $item):?>
							<div class="testimonial-block-two">
								<div class="inner-box">
									<!-- Upper Box -->
									<div class="upper-box">
										<div class="d-flex justify-content-between align-items-center flex-wrap">
											<div class="title"><?php echo esc_html($item['rating_title']);?></div>
											<div class="rating">
                                                <?php for($i = 0; $i < $item['rating']; $i++):?>
												    <span class="fa fa-star"></span>
                                                <?php endfor;?>
											</div>
										</div>
                                        <?php if(!empty($item['feedback'])):?>
										    <div class="text"><?php echo wp_kses( $item['feedback'], true );?></div>
                                        <?php endif;?>
										<div class="d-flex justify-content-between align-items-center flex-wrap">
                                            <?php if($item['authore_signature']['url']):?>
                                                <div class="signature">
                                                    <img src="<?php echo esc_url($item['authore_signature']['url']);?>" alt="" />
                                                </div>
                                            <?php endif;?>
                                            <?php if(!empty($item['quote_icon']['url'])):?>
											<div class="quote"><img src="<?php echo esc_url($item['quote_icon']['url']);?>" alt="" /></div>
                                            <?php endif;?>
										</div>
									</div>
									<!-- Lower Box -->
									<div class="lower-box">
										<!-- Author Box -->
										<div class="author-box">
											<div class="box-inner">
                                                <?php if(!empty($item['authore_img']['url'])):?>
												<span class="author-image">
													<img src="<?php echo esc_url($item['authore_img']['url']);?>" alt="" />
												</span>
                                                <?php endif;?>
												<strong><?php echo esc_html($item['authore_name']);?></strong>
												<?php echo esc_html($item['designation']);?>
											</div>
										</div>
									</div>
								</div>
							</div>
							<?php endforeach;?>
						</div>
					</div>
				</div>
				
				<!-- Form Column -->
				<div class="form-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						
						<!-- Title Box -->
                        <?php if(!empty($settings['form_title'])):?>
                            <div class="title-box">
                                <h1><?php echo wp_kses( $settings['form_title'], true )?></h1>
                            </div>
						<?php endif;?>
						<!-- Solution Form -->
                        <?php if(!empty($settings['form_shortcode'])):?>
						<div class="solution-form">
							<?php echo do_shortcode( $settings['form_shortcode'] );?>
						</div>
                        <?php endif;?>
						<!-- End Default Form -->
						
					</div>
				</div>
				
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Testimonial_Quote() );