<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Team extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-team-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Team Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'authore', [
				'label' => esc_html__( 'Team Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'name', [
				'label' => esc_html__( 'Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'link_to_single_page', [
				'label' => esc_html__( 'Team Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'social_icon', [
				'label' => esc_html__( 'Social Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_link', [
				'label' => esc_html__( 'Social Icon', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'social_icons',
			[
				'label' => esc_html__( 'Add Social Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="team-block">
        <div class="inner-box">
            <div class="image">
                <a href="<?php if(!empty($settings['link_to_single_page']['url'])){echo esc_url($settings['link_to_single_page']['url']);}?>"><img src="<?php echo esc_url($settings['authore']['url']);?>" alt="" /></a>
                <!-- Social Box -->
                <ul class="social-box">
                    <?php foreach($settings['social_icons'] as $item):?>
                    <li><a href="<?php echo esc_url($item['social_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                    <?php endforeach;?>
                </ul>
            </div>
            <div class="lower-content">
                <h5><a href="<?php if(!empty($settings['link_to_single_page']['url'])){echo esc_url($settings['link_to_single_page']['url']);}?>"><?php echo esc_html($settings['name']);?></a></h5>
                <div class="designation"><?php echo esc_html($settings['designation']);?></div>
            </div>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Team() );