<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Team_Details extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-tm-singel-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Details', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Social Icons Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'image', [
				'label' => esc_html__( 'Team Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'name', [
				'label' => esc_html__( 'Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'short_bio', [
				'label' => esc_html__( 'Short Bio', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'skill_heading', [
				'label' => esc_html__( 'Skill Heading', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'progress_count', [
				'label' => esc_html__( 'Progress Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'progress_title', [
				'label' => esc_html__( 'Progress Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'progress_bar',
			[
				'label' => esc_html__( 'Add Progress Bar', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ progress_title }}}',
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'socials_icon',
			[
				'label' => esc_html__( 'Add Social Icon', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="team-detail">
        <div class="auto-container">
            <div class="row clearfix">
                
                <!-- Team Column -->
                <?php if(!empty($settings['image']['url'])):?>
                <div class="image-column col-lg-5 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="image">
                            <img src="<?php echo esc_url($settings['image']['url']);?>" alt="" />
                        </div>
                    </div>
                </div>
                <?php endif;?>
                <!-- Content Column -->
                <div class="content-column col-lg-7 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <h2><?php echo esc_html($settings['name']);?></h2>
                        <div class="designation"><?php echo esc_html($settings['designation']);?></div>
                        <div class="text"><?php echo wp_kses( $settings['short_bio'], true )?></div>
                        <h6><?php echo esc_html($settings['skill_heading']);?></h6>
                        
                        <!-- Skills -->
                        <?php if(!empty($settings['progress_bar'])): ?>
                        <div class="skills">

                            <!-- Skill Item -->
                            <?php foreach($settings['progress_bar'] as $item):?>
                            <div class="skill-item">
                                <div class="skill-header clearfix">
                                    <div class="skill-title"><?php echo esc_html($item['progress_title']);?></div>
                                </div>
                                <div class="skill-bar">
                                    <div class="bar-inner">
                                        <div class="bar progress-line" data-width="<?php echo esc_attr($item['progress_count']);?>">
                                            <div class="skill-percentage"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr($item['progress_count']);?>">0</span>%</div>
                            </div>
                            <?php endforeach;?>
                        </div>
                        <?php endif;?>

                        <!-- Social Box -->
                        <?php if(!empty($settings['socials_icon'])): ?>
                        <ul class="social-box">
                            <?php foreach($settings['socials_icon'] as $item):?>
                                <li><a href="<?php echo esc_url($item['link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                            <?php endforeach;?>
                        </ul>
                        <?php endif;?>
                    </div>
                </div>
                
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Team_Details() );