<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Team_tw_Carousel extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-team-carousel-tw-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Carousel Two', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Team Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Team Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Name', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'link_to_single_page', [
				'label' => esc_html__( 'Team Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_1_icon', [
				'label' => esc_html__( 'Social 1 Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_1_link', [
				'label' => esc_html__( 'Social Link One', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'social_2_icon', [
				'label' => esc_html__( 'Social 2 Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_2_link', [
				'label' => esc_html__( 'Social Link Two', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'social_3_icon', [
				'label' => esc_html__( 'Social 3 Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_3_link', [
				'label' => esc_html__( 'Social Link Three', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'social_4_icon', [
				'label' => esc_html__( 'Social 4 Icon', 'constim-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'social_4_link', [
				'label' => esc_html__( 'Social Link Four', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'teams',
			[
				'label' => esc_html__( 'Add Team Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="team-three">
        <div class="team-three_pattern-layer" <?php if(!empty($settings['shape']['url'])):?>style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)"></div> <?php endif;?>
            <div class="auto-container">
                <!-- Sec Title Two -->
                <div class="sec-title-two light">
                    <div class="sec-title-two_title"><?php echo esc_html($settings['subtitle']);?></div>
                    <h2 class="sec-title-two_heading"><?php echo esc_html($settings['title']);?></h2>
                </div>
                <div class="team-carousel-two owl-carousel owl-theme">
                    
                    <!-- Team Two -->
                    <?php foreach($settings['teams'] as $item):?>
                    <div class="team-two">
                        <div class="team-two_inner-box">
                            <div class="team-two_image">
                                <a href="<?php echo esc_url($item['link_to_single_page']['url']);?>"><img src="<?php echo esc_url($item['authore']['url']);?>" alt="" /></a>
                                <!-- Social Box -->
                                <ul class="team-two_social">
                                    <?php if(!empty($item['social_1_icon'])):?>
										<li><a href="<?php echo esc_url($item['social_1_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_1_icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
									<?php endif;?>

									<?php if(!empty($item['social_2_icon'])):?>
										<li><a href="<?php echo esc_url($item['social_2_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_2_icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
									<?php endif;?>

									<?php if(!empty($item['social_3_icon'])):?>
										<li><a href="<?php echo esc_url($item['social_3_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_3_icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
									<?php endif;?>

									<?php if(!empty($item['social_4_icon'])):?>
										<li><a href="<?php echo esc_url($item['social_4_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_4_icon'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
									<?php endif;?>
                                </ul>
                            </div>
                            <div class="team-two_lower-content">
                                <h5><a href="<?php echo esc_url($item['link_to_single_page']['url']);?>"><?php echo esc_html($item['name']);?></a></h5>
                                <div class="team-two_designation"><?php echo esc_html($item['designation']);?></div>
                                <a class="team-two_plus theme-btn fa-solid fa-plus fa-fw" href="<?php echo esc_url($item['link_to_single_page']['url']);?>"></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Team_tw_Carousel() );