<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Contact_Info extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-contact-info-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Info', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		
		$this->add_control(
			'h_title', [
				'label' => esc_html__( 'Heading Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'arrow_down', [
				'label' => esc_html__( 'Arrwo Down', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'house_icon', [
				'label' => esc_html__( 'House Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'list_item', [
				'label' => esc_html__( 'List Item', 'constim-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'contact_infos',
			[
				'label' => esc_html__( 'Add Contact Info Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		
		$this->add_control(
			'quote_title', [
				'label' => esc_html__( 'Quote Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'quote_form', [
				'label' => esc_html__( 'Quote Form Shortcode', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'thm_clr',
            [
                'label' => esc_html__('Theme color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2 span,{{WRAPPER}} .solution-section .content-column h3 span,{{WRAPPER}} .solution-section .form-column .title-box h1 span' => 'color: {{VALUE}};',
					'{{WRAPPER}} .btn-style-two' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Big Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .sec-title .big-title',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .big-title' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_hg',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tt_typ',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            ]
        );

        $this->add_control(
            'tt_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'ly_hg',
            [
                'label' => esc_html__('List', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ly_typ',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .solution-section .content-column .list li',
            ]
        );

        $this->add_control(
            'ly_clr2',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solution-section .content-column .list li' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'loc_hg',
            [
                'label' => esc_html__('Location', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ly_typ_2',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .solution-section .content-column .list li',
            ]
        );

        $this->add_control(
            'ly_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solution-section .content-column .list li' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'fl_hg',
            [
                'label' => esc_html__('Form label', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'fl_typ',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .solution-form .form-group label',
            ]
        );

        $this->add_control(
            'fl_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .solution-form .form-group label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="solution-section">
        <?php if(!empty($settings['shape']['url'])):?>
		<div class="icon-layer award__text-2">
			<img src="<?php echo esc_url($settings['shape']['url']);?>" alt="" />
		</div>
        <?php endif;?>
		<div class="auto-container">
			<!-- Sec Title -->
			<div class="sec-title">
                <?php if(!empty($settings['bigtitle'])):?>
                    <div class="big-title"><?php echo esc_html($settings['bigtitle']);?></div>
                <?php endif;?>
				<?php if(!empty($settings['h_title'])):?>
                    <h2><?php echo wp_kses( $settings['h_title'], true )?></h2>
                <?php endif;?>
                <?php if(!empty($settings['arrow_down']['url'])):?>
                    <div class="arrow"><img src="<?php echo esc_url($settings['arrow_down']['url']);?>" alt="" /></div>
                <?php endif;?>
			</div>
			<div class="row clearfix">
				<!-- Content Column -->
				<div class="content-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<h3><?php echo wp_kses( $settings['title'], true )?></h3>
						<!-- Info Box -->
						<div id="animation_wrapper">
							<div class="info-box btn-item">
                                <?php if(!empty($settings['house_icon']['url'])):?>
								    <span class="icon"><img src="<?php echo esc_url($settings['house_icon']['url']);?>" alt="" /></span>
                                <?php endif;?>
                                <?php if(!empty($settings['list_item'])):?>
								<div class="list">
                                    <?php echo wp_kses( $settings['list_item'], true )?>
								</div>
                                <?php endif;?>
							</div>
						</div>
						<!-- End Info Box -->
						
						<div class="row clearfix">
						
							<!-- Location Box -->
                            <?php foreach($settings['contact_infos'] as $item):?>
							<div class="location-box col-lg-6 col-md-6 col-sm-12">
								<div class="box-inner">
									<h4><?php echo esc_html($item['title']);?></h4>
									<div class="location-text"><?php echo wp_kses( $item['description'], true );?></div>
								</div>
							</div>
							<?php endforeach;?>
						</div>
						
					</div>
				</div>
				<!-- Form Column -->
				<div class="form-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<!-- Title Box -->
                        <?php if(!empty($settings['quote_title'])):?>
                            <div class="title-box">
                                <h1><?php echo wp_kses( $settings['quote_title'], true );?></h1>
                            </div>
						<?php endif;?>
						<!-- Solution Form -->
						<div class="solution-form">
							<?php echo do_shortcode( $settings['quote_form'] );?>
						</div>
						<!-- End Default Form -->
						
					</div>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Contact_Info() );