<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Sidebar_Quote extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-sidebar-quote-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Sidebar Quote', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_quote_option',
			[
				'label' => esc_html__( 'Sidebar Quote', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'help_img', [
				'label' => esc_html__( 'Help Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'phone_no', [
				'label' => esc_html__( 'Phone No', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'openign_titme', [
				'label' => esc_html__( 'Opening Time', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'call_btn', [
				'label' => esc_html__( 'Call Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="sidebar-widget help-widget">
        <div class="image">
            <?php if(!empty($settings['help_img']['url'])):?>
                <img src="<?php echo esc_url($settings['help_img']['url']);?>" alt="" />
            <?php endif;?>
            <?php if(!empty($settings['title'])):?>
            <div class="overlay-box">
                <h5><?php echo wp_kses( $settings['title'], true );?></h5>
            </div>
            <?php endif;?>
        </div>
        <div class="content">
            <a class="phone" href="tel:<?php echo esc_url($settings['phone_no']);?>"><?php echo esc_html($settings['phone_no']);?></a>
            <?php if(!empty($settings['openign_titme'])):?>
                <div class="text"><?php echo wp_kses( $settings['openign_titme'], true )?></div>
            <?php endif;?>
            <?php if(!empty($settings['call_btn'])):?>
                <a class="call theme-btn" href="tel:<?php echo esc_url($settings['phone_no']);?>"><?php echo esc_html($settings['call_btn']);?></a>
            <?php endif;?>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Sidebar_Quote() );