<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Services_Tabs extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-services-tabs-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Tab', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'constim-tools' ),
				'label_off' => esc_html__( 'NO', 'constim-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'tab_title', [
				'label' => esc_html__( 'Tab Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'postorder',
			[
				'label'     => esc_html__( 'Post Order', 'constim-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'constim-tools' ),
					'DESC' => esc_html__( 'Descending', 'constim-tools' ),
				],
			]
		);
		
		$repeater->add_control(
			'pst_per_page',
			[
				'label'   => __( 'Posts Per Page', 'constim-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 1,
			]
		);
		$repeater->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'hostix-tools'),
			  'label_block' => true,
			  'options' => constim_service_category()
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Add Service Category Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'thm',
            [
                'label' => esc_html__('Theme Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block.style-two .inner-box,{{WRAPPER}} .service-block .inner-box:hover' => 'background: {{VALUE}};',
                ],
            ]     
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Big Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .services-section .title-box .big-title',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-section .title-box .big-title' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'st_bg',
            [
                'label' => esc_html__('Small Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'st_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .services-section .title-box h2',
            ]
        );

        $this->add_control(
            'st_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-section .title-box h2' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'ft_bg',
            [
                'label' => esc_html__('Filter', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ft_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .trending-tab .tab-btns-box .p-tab-btn',
            ]
        );

        $this->add_control(
            'ft_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trending-tab .tab-btns-box .p-tab-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'ft_clhr',
            [
                'label' => esc_html__('Hover Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .trending-tab .tab-btns-box .p-tab-btn:hover,{{WRAPPER}} .trending-tab .tab-btns-box .p-tab-btn.active-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_pst',
            [
                'label' => esc_html__('Post grid', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pstyp',
                'label' => esc_html__('Title Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .service-block h3',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'dstyp',
                'label' => esc_html__('Description Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .service-block .text p',
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
		extract($settings);
    ?>
    <section class="services-section">
		<div class="outer-container">
			<!-- Title Box -->
			<div class="title-box">
				<?php if(!empty($bigtitle)):?>
					<div class="big-title title-anim"><?php echo esc_html($bigtitle);?></div>
				<?php endif;?>
				<?php if(!empty($title)):?>
					<h2 class="title-anim"><?php echo esc_html($title);?></h2>
				<?php endif;?>
				<?php if(!empty($arrow_icon)):?>
					<div class="arrow title-anim"><img src="<?php echo esc_url($arrow_icon['url']);?>" alt="" /></div>
				<?php endif;?>
			</div>
			
			<!-- Trending Tabs -->
			<div class="trending-tab">

				<div class="tab-btns-box">
					<!-- Tabs Header -->
					<div class="tabs-header">
						<ul class="product-tab-btns clearfix">
							<?php foreach($tabs as $item):?>
								<li class="p-tab-btn <?php if($item['is_active'] == 'yes'):?> active-btn <?php endif;?>" data-tab="#p-tab-<?php echo esc_attr($item['_id']);?>"><?php echo esc_html($item['tab_title']);?></li>
							<?php endforeach;?>
						</ul>
					</div>
				</div>
				
				<!--Tabs Content-->  
				<div class="p-tabs-content">
				
					<!-- Portfolio Tab / Active Tab -->
					<?php foreach($tabs as $item):?>
					<div class="p-tab <?php if($item['is_active'] == 'yes'):?> active-tab <?php endif;?>" id="p-tab-<?php echo esc_attr($item['_id']);?>">
						<div class="project-carousel owl-theme owl-carousel">
						<?php				
							$args = array(
								'post_type'           => 'service',
								'posts_per_page'      => !empty( $item['pst_per_page'] ) ? $item['pst_per_page'] : 1,
								'post_status'         => 'publish',
								'ignore_sticky_posts' => 1,
								'order'               => $item['postorder'],
							);
							if( $item['query_category'] ) $args['services_cate'] = $item['query_category'];
							$query = new \WP_Query( $args );
							?>
							<?php
							if ( $query->have_posts() ) {
							while ( $query->have_posts() ) {
							$query->the_post();
							$constim_size = 'full';

							$term_list = wp_get_post_terms(get_the_id(), 'services_cate', array("fields" => "names"));

							if(get_post_meta(get_the_ID(), 'constim_service_meta', true)) {
								$service_meta = get_post_meta(get_the_ID(), 'constim_service_meta', true);
							} else {
								$service_meta = array();
							}
						
							if( array_key_exists( 'service_img_icon', $service_meta )) {
								$service_img_icon = $service_meta['service_img_icon'];
							} else {
								$service_img_icon = '';
							}
							if( array_key_exists( 'service-style', $service_meta )) {
								$service_style = $service_meta['service-style'];
							} else {
								$service_style = '';
							}
							if( array_key_exists( 'sub_cate_name', $service_meta )) {
								$sub_cate_name = $service_meta['sub_cate_name'];
							} else {
								$sub_cate_name = '';
							}
						?>
							<!-- Service Block -->
							<div class="service-block <?php if(!empty($service_style)){ echo esc_attr($service_style);}?>">
								<div class="inner-box">
									<a href="<?php the_permalink();?>" class="image-layer" style="background-image: url(<?php echo get_the_post_thumbnail_url(get_the_ID(), $constim_size);?>)"></a>
									<div class="content">
										<div class="title"><?php echo implode( ', ', (array)$term_list );?></div>
										<?php if(!empty($service_img_icon['url'])):?>
										<div class="icon">
											<img src="<?php echo esc_url($service_img_icon['url']);?>" alt="" />
										</div>
										<?php endif;?>
										<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
										<div class="text"><?php the_excerpt()?></div>
										<a class="arrow flaticon-045-right-arrow-1" href="<?php the_permalink();?>"></a>
									</div>
								</div>
							</div>
							<?php } ?>
                			<?php wp_reset_query(); } ?>
						</div>
					</div>
					<?php endforeach;?>
				</div>
			</div>
			
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Services_tabs() );