<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class service_seven extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'service-seven';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service 7', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Sub title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Our services', true)
            ]
        );

		$this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Quality servicing opportunity', true)
            ]
        );

		$this->add_control(
			'info',
			[
				'label' => esc_html__('Info', 'thepack'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __('We love small plumbing jobs!!! We have plumbers on the road local to you who can complete <br> your small plumbing jobs at your convenience.', true)
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'service_img',
            [
                'label' => esc_html__('Service Image', 'thepack'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true
            ]
        );

		$repeater->add_control(
			'service_title',
			[
				'label' => esc_html__('Service Title', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Morina Villa', true)
			]
		);

		$repeater->add_control(
			'service_designation',
			[
				'label' => esc_html__('Service Designation', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Indoor', true)
			]
		);

		$repeater->add_control(
            'service_link',
            [
                'label' => esc_html__('Service Link', 'thepack'),
                'type' => Controls_Manager::URL,
                'label_block' => true
            ]
        );

		$this->add_control(
            'list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
                'default' => [
	                [
		                'service_title' => esc_html__( 'Morina Villa', 'textdomain' ),
	                ],
	                [
		                'service_title' => esc_html__( 'Morina Villa', 'textdomain' ),
	                ],
	                [
		                'service_title' => esc_html__( 'Morina Villa', 'textdomain' ),
	                ],
	                [
		                'service_title' => esc_html__( 'Morina Villa', 'textdomain' ),
	                ],
	                [
		                'service_title' => esc_html__( 'Morina Villa', 'textdomain' ),
	                ],
                ],
                'title_field' => '{{{ service_title }}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_title',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Description-Style--',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Service_style_1',
			[
				'label' => __( 'Service Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Service-Title-Color',
			[
				'label' => esc_html__( 'Service Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-seven_title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-Title-Typography',
				'label' => esc_html__( 'Service Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .service-seven_title a',
			]
		);
		$this->add_control(
			'Service-info-Color',
			[
				'label' => esc_html__( 'Service info Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-seven_designation' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-info-Typography',
				'label' => esc_html__( 'Service info Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .service-seven_designation',
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Service-Title-Hover-Color',
			[
				'label' => esc_html__( 'Service Title Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-seven_title a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();



	}


	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>

    <!-- Services Seven -->
    <div class="services-seven">
        <div class="auto-container">
            <div class="sec-title-two centered">
                <div class="sec-title-two_title"><?php echo esc_html( $settings['subtitle'] ); ?></div>
                <h2 class="sec-title-two_heading"><?php echo esc_html( $settings['title'] ); ?></h2>
                <div class="sec-title-two_text"><?php echo wp_kses( $settings['info'], true ); ?></div>
            </div>
        </div>
        <div class="services-seven_outer-container">
            <div class="four-item-carousel owl-carousel owl-theme">

                <?php foreach ($settings['list'] as $item): ?>
                <!-- Service Block Six -->
                <div class="service-block_seven">
                    <div class="service-seven_inner">
                        <div class="service-seven_image">
                            <img src="<?php echo esc_url($item['service_img']['url']) ?>" alt="" />
                            <div class="service-block_seven-overlay">
                                <div class="service-block_seven-content">
                                    <h5 class="service-seven_title"><a href="<?php echo esc_url($item['service_link']['url']) ?>"><?php echo esc_html($item['service_title']); ?></a></h5>
                                    <div class="service-seven_designation"><?php echo esc_html($item['service_designation']); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- End Services Seven -->

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new service_seven() );