<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Service_Info extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-service-info-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Info', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Shape Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'bg_shape', [
				'label' => esc_html__( 'Background Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_arrow', [
				'label' => esc_html__( 'Button Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'services',
			[
				'label' => esc_html__( 'Add Service Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->add_control(
			'service_image', [
				'label' => esc_html__( 'Service Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
        <section class="services-section-three" style="background-image:url(<?php echo esc_url($settings['bg_shape']['url']);?>)">
            <div class="auto-container">
                <div class="inner-container">
                    <!-- Title Box -->
                    <div class="title-box">
                        <div class="d-flex justify-content-between">
                            <!-- Left Box -->
                            <div class="left-box">
                                <h2><?php echo wp_kses( $settings['title'], true )?></h2>
                                <div class="text"><?php echo wp_kses( $settings['description'], true )?></div>
                            </div>
                            
                            <!-- Right Box -->
                            <?php if(!empty($settings['button_label'])):?>
                            <div class="right-box">
                                <!-- Info Box -->
                                <div id="animation_wrapper">
                                    <a class="btn-style-one theme-btn btn-item" href="<?php echo esc_url($settings['button_link']['url']);?>">
                                        <div class="btn-wrap">
                                            <span class="text-one"><?php echo esc_html($settings['button_label']);?></span>
                                            <span class="text-two"><?php echo esc_html($settings['button_label']);?></span>
                                        </div>
                                        <?php if($settings['button_arrow']['url']):?>
                                            <i class="arrow"><img src="<?php echo esc_url($settings['button_arrow']['url']);?>" alt="" /></i>
                                        <?php endif;?>
                                    </a>
                                </div>
                            </div>
                            <?php endif;?>
                        </div>
                    </div>
                    <!-- End Title Box -->
                    
                    <div class="row clearfix">
                        
                        <!-- Content Column -->
                        <div class="content-column col-lg-7 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <div class="row clearfix">
                                
                                    <!-- Service Block Three -->
                                    <?php foreach($settings['services'] as $item):?>
                                    <div class="service-block-three col-lg-6 col-md-6 col-sm-12">
                                        <div class="inner-box title-anim">
                                        <h5><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h5>
                                            <div class="text"><?php echo wp_kses( $item['description'], true )?></div>
                                        </div>
                                    </div>
                                    <?php endforeach;?>
                                    
                                </div>
                            </div>
                        </div>
                        
                        <!-- Image Column -->
                        <?php if($settings['service_image']['url']):?>
                        <div class="image-column col-lg-5 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <div class="image">
                                    <img src="<?php echo esc_url($settings['service_image']['url']);?>" alt="" />
                                </div>
                            </div>
                        </div>
                        <?php endif;?>
                    </div>
                    
                </div>
            </div>
        </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Service_Info() );