<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Service_5 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-srv5';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service 5', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'pre',
            [
                'label' => esc_html__('Pre title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$this->add_control(
            'ttl',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$this->add_control(
			'desc',
			[
				'label' => esc_html__('Description', 'thepack'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'img',
            [
                'label' => esc_html__('Thumbnail', 'thepack'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'icn',
            [
                'label' => esc_html__('Icon', 'thepack'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'url',
            [
                'label' => esc_html__('Link', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'ttl',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'thepack'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true
            ]
        );

		$this->add_control(
            'items',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ ttl }}}',
            ]
        );

		$this->add_control(
            'lower-Text',
            [
                'label' => esc_html__('Lower text', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('See more carpenter services click the button', 'thepack')
            ]
        );

		$this->add_control(
			'button-text',
			[
				'label' => esc_html__('Button text', 'thepack'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Read More', 'thepack')
			]
		);
		$this->add_control(
			'button-link',
			[
				'label' => esc_html__('Button Link', 'thepack'),
				'type' => Controls_Manager::URL,
				'label_block' => true
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_title',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Description-Style--',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Service_style_1',
			[
				'label' => __( 'Service Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Service-Title-Color',
			[
				'label' => esc_html__( 'Service Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-six_title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-Title-Typography',
				'label' => esc_html__( 'Service Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .service-six_title a',
			]
		);
		$this->add_control(
			'Service-Info-Color',
			[
				'label' => esc_html__( 'Service Info Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-six_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-Info-Typography',
				'label' => esc_html__( 'Service Info Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .service-six_text',
			]
		);
		$this->add_control(
			'Service-Button-Color',
			[
				'label' => esc_html__( 'Service Button Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-six_read-more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Service-Button-Typography',
				'label' => esc_html__( 'Service Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .service-six_read-more',
			]
		);
		$this->add_control(
			'Service-Nav-Arrow-Color',
			[
				'label' => esc_html__( 'Service Nav Arrow Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-five .owl-nav .owl-prev' => 'color: {{VALUE}}',
					'{{WRAPPER}} .services-five .owl-nav .owl-next' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Nav-Arrow-Border-Color',
			[
				'label' => esc_html__( 'Service Nav Arrow Border Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-five .owl-nav .owl-prev' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .services-five .owl-nav .owl-next' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Service-Title-Hover-Color',
			[
				'label' => esc_html__( 'Service Title Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-six_title a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Button-Hover-Color',
			[
				'label' => esc_html__( 'Service Button Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-six_read-more:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Nav-Arrow-Hover-Color',
			[
				'label' => esc_html__( 'Service Nav Arrow Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-five .owl-nav .owl-prev:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .services-five .owl-nav .owl-next:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Nav-Arrow-Hover-Border-Color',
			[
				'label' => esc_html__( 'Service Nav Arrow Hover Border Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-five .owl-nav .owl-prev:hover' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .services-five .owl-nav .owl-next:hover' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Nav-Arrow-BG-Color',
			[
				'label' => esc_html__( 'Service Nav Arrow BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-five .owl-nav .owl-prev:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .services-five .owl-nav .owl-next:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'Lower-text_style_1',
			[
				'label' => __( 'Lower Text Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'Lower-Text-Color',
			[
				'label' => esc_html__( 'Lower Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .services-four_lower-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Lower-Text-Typography',
				'label' => esc_html__( 'Lower Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .services-four_lower-text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Button_style_1',
			[
				'label' => __( 'Button Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcntb');
		$this->start_controls_tab(
			'tab_controls_normalb',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Color',
			[
				'label' => esc_html__( 'Button Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five .btn-wrap .text-one' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Typography',
				'label' => esc_html__( 'Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .btn-style-five',
			]
		);
		$this->add_control(
			'Button-Background-Color',
			[
				'label' => esc_html__( 'Button Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hoverb',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Hover-Color',
			[
				'label' => esc_html__( 'Button Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover .btn-wrap .text-two' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five:hover .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-Background-Color',
			[
				'label' => esc_html__( 'Button Hover Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


	}


	protected function render() {
		$settings = $this->get_settings_for_display();	

		$out1 = '';
        foreach ($settings['items'] as $item) {
            $out1 .= '
				<div class="service-block_six">
					<div class="service-six_inner">
						<div class="service-six_image">
							<a href="'.$item['url'].'"><img src="'.$item['img']['url'].'" alt="" /></a>
						</div>
						<div class="service-six_lower-content">
							<span class="service-six_icon">
								<img src="'.$item['icn']['url'].'" alt="" />
							</span>
							<h5 class="service-six_title"><a href="'.$item['url'].'">'.$item['ttl'].'</a></h5>
							<div class="service-six_text">'.$item['desc'].'</div>
							<a class="service-six_read-more" href="'.$item['url'].'">read more</a>
						</div>
					</div>
				</div>			
			';
        }

    ?>

<section class="services-five">
		<div class="auto-container">
			<div class="sec-title-two centered">
				<div class="sec-title-two_title"><?php echo $settings['pre'];?></div>
				<h2 class="sec-title-two_heading"><?php echo $settings['ttl'];?></h2>
				<div class="sec-title-two_text"><?php echo $settings['desc'];?></div>
			</div>
			<div class="three-item-carousel owl-carousel owl-theme">
				
				<!-- Service Six -->
				<?php echo $out1;?>
			
			</div>
			
			<div class="about-two_lower-box text-center clearfix">
				<div class="services-four_lower-text"><?php echo $settings['lower-Text']; ?></div>
				<a class="btn-style-five theme-btn btn-item" href="<?php echo $settings['button-link']['url']; ?>" target="<?php if ($settings['button-link']['is_external']) echo '_blank'; ?>">
					<div class="btn-wrap">
						<span class="text-one"><?php echo $settings['button-text']; ?></span>
						<span class="text-two"><?php echo $settings['button-text']; ?></span>
					</div>
					<i class="arrow fa-solid fa-arrow-right fa-fw"></i>
				</a>
			</div>
			
		</div>
	</section>

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Service_5() );