<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Services_3 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-services-3-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service 3', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'service_icon',
			[
				'label' => esc_html__( 'Upload Service Image', 'textdomain' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'include' => [],
				'default' => 'large',
			]
		);
		$repeater->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        

		$this->add_control(
			'services',
			[
				'label' => esc_html__( 'Add Service Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
		extract($settings);
    ?>
    <section class="solution-section-two">
		<div class="auto-container">
			<!-- Sec Title -->
			<div class="sec-title">
                <div class="d-flex justify-content-between align-items-center">
                    <!-- Left Box -->
                    <div class="left-box">
                        <?php if(!empty($settings['bigtitle'])):?>
                            <div class="big-title"><?php echo esc_html($settings['bigtitle']);?></div>
                        <?php endif;?>
                        <?php if(!empty($settings['title'])):?>
                            <h2><?php echo wp_kses( $settings['title'], true )?></h2>
                        <?php endif;?>
                        <?php if(!empty($settings['arrow_icon']['url'])):?>
                            <div class="arrow"><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt="" /></div>
                        <?php endif;?>
                    </div>
                    <!-- Right Box -->
                    <div class="right-box">
                        <div class="text"><?php echo wp_kses( $settings['description'], true );?></div>
                    </div>
                </div>
            </div>
			<div class="inner-container">
				<div class="clearfix">
					
					<!-- Service Block -->
                    <?php foreach($settings['services'] as $item):?>
					<div class="service-block_four col-lg-4 col-md-6 col-sm-12">
						<div class="service-four_inner-box">
							<div class="service-four_icon">
								<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'service_icon' );?>
							</div>
                            <?php if(!empty($item['subtitle'])):?>
							    <div class="service-four_title"><?php echo esc_html($item['subtitle']);?></div>
                            <?php endif;?>
                            <?php if(!empty($item['title'])):?>
							    <h4 class="service-four_heading"><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo wp_kses( $item['title'], true );?></a></h4>
                            <?php endif;?>
						</div>
					</div>
					<?php endforeach;?>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Services_3() );