<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Section_Heading extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-section-title-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Section Title', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__( 'Style One', 'constim-tools' ),
					'2' => esc_html__( 'Style Two', 'constim-tools' ),
					'3' => esc_html__( 'Style Three', 'constim-tools' ),
				],
			]
		);
		
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
				'condition' => [
					'style' => '3',
				],
			]
		);
		
		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'arrow-bt_icon', [
				'label' => esc_html__( 'Button Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'alignment',
			[
				'label' => esc_html__( 'Alignment', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'constim-tools' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'constim-tools' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'constim-tools' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            't_clr',
            [
                'label' => esc_html__('Theme Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2 span' => 'color: {{VALUE}};',
					'{{WRAPPER}} .btn-style-one' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'tt_bg',
            [
                'label' => esc_html__('Big Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bt_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .sec-title .big-title',
            ]
        );

        $this->add_control(
            'bt_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .big-title' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Big Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            ]
        );

        $this->add_control(
            't_clr2',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .btn-style-one',
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
	<?php if($settings['style'] == '1'):?>
    <div class="sec-title">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <!-- Left Box -->
            <div class="left-box">
                <?php if(!empty($settings['bigtitle'])):?>
                <div class="big-title"><?php echo esc_html($settings['bigtitle']);?></div>
                <?php endif;?>
                <?php if(!empty($settings['title'])):?>
                    <h2><?php echo wp_kses( $settings['title'], true )?></h2>
                <?php endif;?>
                <?php if(!empty($settings['arrow_icon']['url'])):?>
                <div class="arrow"><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt="" /></div>
                <?php endif;?>
            </div>
            <!-- Right Box -->
            <?php if(!empty($settings['btn_label'])):?>
            <div class="right-box">
                <a class="btn-style-one theme-btn" href="<?php echo esc_url($settings['btn_link']['url']);?>">
                    <div class="btn-wrap">
                        <span class="text-one"><?php echo esc_html($settings['btn_label']);?></span>
                        <span class="text-two"><?php echo esc_html($settings['btn_label']);?></span>
                    </div>
                    <i class="arrow fa-regular fa-arrow-up-right"></i>
                </a>
            </div>
            <?php endif;?>
        </div>
    </div>
	<?php elseif($settings['style'] == '3'):?>
	<div class="sec-title">
		<div class="d-flex justify-content-between align-items-center">
			<!-- Left Box -->
			<div class="left-box">
				<?php if(!empty($settings['bigtitle'])):?>
                	<div class="big-title"><?php echo esc_html($settings['bigtitle']);?></div>
                <?php endif;?>
				<?php if(!empty($settings['title'])):?>
                    <h2><?php echo wp_kses( $settings['title'], true )?></h2>
                <?php endif;?>
				<?php if(!empty($settings['arrow_icon']['url'])):?>
                	<div class="arrow"><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt="" /></div>
                <?php endif;?>
			</div>
			<!-- Right Box -->
			<div class="right-box">
				<div class="text"><?php echo wp_kses( $settings['description'], true );?></div>
			</div>
		</div>
	</div>
	<?php else:?>
	<div class="sec-title text-<?php echo esc_attr($settings['alignment']);?>">
		<?php if(!empty($settings['bigtitle'])):?>
			<div class="big-title title-anim"><?php echo esc_html($settings['bigtitle']);?></div>
		<?php endif;?>
		<?php if(!empty($settings['title'])):?>
			<h2 class="title-anim"><?php echo wp_kses( $settings['title'], true )?></h2>
		<?php endif;?>
		<div class="arrow fa-solid fa-arrow-down fa-fw"></div>
	</div>
	<?php endif;?>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Section_Heading() );