<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Project_Item extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-project-item-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Item', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'button', [
				'label' => esc_html__( 'Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'projects_item',
			[
				'label' => esc_html__( 'Projects Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->add_control(
			'btn_arrwo', [
				'label' => esc_html__( 'Button Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
	<section class="project-section-two">
		<div class="auto-container">
			<!-- Sec Title -->
			<div class="sec-title">
                <?php if($settings['bigtitle']):?>
				    <div class="big-title title-anim"><?php echo wp_kses( $settings['bigtitle'], true )?></div>
                <?php endif;?>
                <?php if($settings['title']):?>
				    <h2 class="title-anim"><?php echo wp_kses( $settings['title'], true )?></h2>
                <?php endif;?>
                <?php if(!empty($settings['arrow_icon']['url'])):?>
				    <div class="arrow title-anim"><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt="" /></div>
                <?php endif;?>
			</div>
		</div>
		<div class="outer-container">
			<div class="project-carousel-two owl-carousel owl-theme">
			
				<!-- Portfolio Block -->
                <?php foreach($settings['projects_item'] as $item):?>
				<div class="portfolio-block">
					<div class="inner-box">
						<div class="image">
                            <?php if(!empty($item['project_img']['url'])):?>
							    <img src="<?php echo esc_url($item['project_img']['url']);?>" alt="" />
                            <?php endif;?>
							<div class="overlay-box">
                                <?php if(!empty($item['count'])):?>
								    <span class="number"><?php echo esc_html($item['count']);?></span>
                                <?php endif;?>
								<!-- Content -->
								<div class="content">
									<h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo wp_kses( $item['title'], true )?></a></h3>
                                    <?php if(!empty($item['link']['url'])):?>
									<a class="detail" href="<?php echo esc_url($item['link']['url']);?>"><?php echo wp_kses( $item['button'], true )?></a>
                                    <?php endif;?>
								</div>
							</div>
						</div>
                        <?php if(!empty($item['button'])):?>
						<div class="lower-box">
							<a class="more-detail" href="<?php echo esc_url($item['link']['url']);?>"><?php echo wp_kses( $item['button'], true )?> <span class="arrow"><img src="<?php echo esc_url($settings['btn_arrwo']['url']);?>" alt="" /></span></a>
						</div>
                        <?php endif;?>
					</div>
				</div>
				<?php endforeach;?>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Project_Item() );