<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Project_Tabs extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-projects-tabs-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Tabs', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Projects Tabs Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'member_title', [
				'label' => esc_html__( 'Member Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'constim-tools' ),
				'label_off' => esc_html__( 'NO', 'constim-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'project_title', [
				'label' => esc_html__( 'Project Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		
		$repeater->add_control(
			'project_image', [
				'label' => esc_html__( 'Project Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'client_logo', [
				'label' => esc_html__( 'Client Logo', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_code', [
				'label' => esc_html__( 'Project Code', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_content', [
				'label' => esc_html__( 'Project Content', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_link', [
				'label' => esc_html__( 'Project Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'link_arrow', [
				'label' => esc_html__( 'Link Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'projects',
			[
				'label' => esc_html__( 'Add Project Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ project_title }}}',
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );		

		$this->add_control(
            'thm',
            [
                'label' => esc_html__('Theme Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-section .members,{{WRAPPER}} .project-section .collection-tabs .tab-btns .tab-btn:hover,{{WRAPPER}} .project-section .collection-tabs .tab-btns .tab-btn.active-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'tc_hd',
            [
                'label' => esc_html__('Circle', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nm_typo',
                'label' => esc_html__('Number Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .project-section .members',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sb_typo',
                'label' => esc_html__('Sub title Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .project-section .members span',
            ]
        );

        $this->add_control(
            'sb_clr',
            [
                'label' => esc_html__('Sub title color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-section .members span' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tt_typo',
                'label' => esc_html__('Title Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .project-section .collection-tabs .tab-btns .tab-btn',
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="project-section">
        <div class="outer-container">
			<div class="clearfix">
				
				<!-- Collection Info Tabs -->
				<div class="collection-info-tabs">
					<!-- Collection Tabs -->
					<div class="collection-tabs tabs-box clearfix">
						
						<!-- Left Column -->
						<div class="left-column clearfix">
							<div class="inner-column">
                                <?php if(!empty($settings['member_title'])):?>
								    <div class="members title-anim"><?php echo wp_kses( $settings['member_title'], true );?></div>
                                <?php endif;?>
								<!-- Tab Btns -->
								<ul class="tab-btns tab-buttons clearfix">
                                    <?php foreach($settings['projects'] as $item):?>
									    <li data-tab="#prod-solution<?php echo esc_attr($item['_id']);?>" class="tab-btn <?php if($item['is_active'] == 'yes'){echo esc_attr('active-btn');}?>"><?php echo esc_html($item['project_title']);?> <span class="arrow"><img src="<?php echo esc_url($item['arrow_icon']['url']);?>" alt="" /></span></li>
                                    <?php endforeach;?>
								</ul>
							</div>
						</div>
						
						<!-- Right Column -->
						<div class="right-column">
							<div class="inner-column">
								<!-- Tabs Container -->
								<div class="tabs-content">
									
									<!-- Tab / Active Tab -->
                                    <?php foreach($settings['projects'] as $item):?>
									<div class="tab <?php if($item['is_active'] == 'yes'){echo esc_attr('active-tab');}?> " id="prod-solution<?php echo esc_attr($item['_id']);?>">
										<div class="content about__img-2">
                                            <?php if(!empty($item['project_image']['url'])):?>
											    <div class="image" data-speed="0.50"><img src="<?php echo esc_url($item['project_image']['url']);?>" alt="" /></div>
                                            <?php endif;?>
											<!-- Overlay Box -->
											<div class="overlay-box">
												<div class="content">
                                                    <?php if(!empty($item['client_logo']['url'])):?>
													    <div class="icon"><img src="<?php echo esc_url($item['client_logo']['url']);?>" alt="" /></div>
                                                    <?php endif;?>
													<?php echo esc_html($item['project_code']);?>
													<span><?php echo esc_html($item['project_content']);?></span>
												</div>
                                                <?php if(!empty($item['link_arrow']['url'])):?>
												    <a class="arrow" href="<?php echo esc_url($item['project_link']['url']);?>"><span><img src="<?php echo esc_url($item['link_arrow']['url']);?>" alt="" /></span></a>
                                                <?php endif;?>
											</div>
										</div>
									</div>
									<?php endforeach;?>
									
								</div>
								
							</div>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Project_Tabs() );