<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Project_Grid extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-project-grid-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Grid', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Project Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button', [
				'label' => esc_html__( 'Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

        $this->add_control(
			'btn_arrwo', [
				'label' => esc_html__( 'Button Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="portfolio-block">
        <div class="inner-box">
            <div class="image">
                <?php if(!empty($settings['project_img']['url'])):?>
                    <img src="<?php echo esc_url($settings['project_img']['url']);?>" alt="" />
                <?php endif;?>
                <div class="overlay-box">
                    <?php if(!empty($settings['count'])):?>
                        <span class="number"><?php echo esc_html($settings['count']);?></span>
                    <?php endif;?>
                    <!-- Content -->
                    <div class="content">
                        <h3><a href="<?php echo esc_url($settings['link']['url']);?>"><?php echo wp_kses( $settings['title'], true )?></a></h3>
                        <?php if(!empty($settings['link']['url'])):?>
                        <a class="detail" href="<?php echo esc_url($settings['link']['url']);?>"><?php echo wp_kses( $settings['button'], true )?></a>
                        <?php endif;?>
                    </div>
                </div>
            </div>
            <?php if(!empty($settings['button'])):?>
            <div class="lower-box">
                <a class="more-detail" href="<?php echo esc_url($settings['link']['url']);?>"><?php echo wp_kses( $settings['button'], true )?> <span class="arrow"><img src="<?php echo esc_url($settings['btn_arrwo']['url']);?>" alt="" /></span></a>
            </div>
            <?php endif;?>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Project_Grid() );