<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Project_Details extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-prg-singel-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Details', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Social Icons Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'project_gallery', [
				'label' => esc_html__( 'Project Image Gallery', 'constim-tools' ),
				'type' => Controls_Manager::GALLERY,
                'label_block' => true,
			]
		);
        $this->add_control(
			'project_title', [
				'label' => esc_html__( 'Project Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'project_desc', [
				'label' => esc_html__( 'Project Description', 'constim-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
        
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'info', [
				'label' => esc_html__( 'Info', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'value', [
				'label' => esc_html__( 'Value', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'project_info',
			[
				'label' => esc_html__( 'Add Project Info', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->add_control(
			'prev_text', [
				'label' => esc_html__( 'Previous Text', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'prev_link', [
				'label' => esc_html__( 'Previous Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'next_text', [
				'label' => esc_html__( 'Next Text', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'next_link', [
				'label' => esc_html__( 'Next Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'grid_img', [
				'label' => esc_html__( 'Grid Img', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="project-detail-section">
		<div class="auto-container">
			<!-- Carousel Box -->
			<div class="carousel-box">
				<div class="single-item-carousel owl-carousel owl-theme">
                    <?php foreach($settings['project_gallery'] as $item):?>
                        <div class="image">
                            <img src="<?php echo esc_url($item['url']);?>" alt="" />
                        </div>
                    <?php endforeach;?>
				</div>
			</div>
			<div class="lower-content">
				<div class="row clearfix">
					<!-- Content Column -->
					<div class="content-column col-lg-8 col-md-12 col-sm-12">
						<div class="inner-column">
							<h2><?php echo wp_kses( $settings['project_title'], true )?></h2>
							<div class="list">
								<?php echo wp_kses( $settings['project_desc'], true );?>
							</div>
						</div>
					</div>
					<!-- Info Column -->
                    <?php if(!empty($settings['project_info'])):?>
					<div class="info-column col-lg-4 col-md-12 col-sm-12">
						<div class="inner-column">
							<ul class="project-info-list">
                                <?php foreach($settings['project_info'] as $item):?>
								    <li><span><?php echo esc_html($item['info']);?></span><?php echo esc_html($item['value']);?></li>
                                <?php endforeach;?>
							</ul>
						</div>
					</div>
                    <?php endif;?>
				</div>
			</div>
			
			<!-- Project More Posts -->
			<div class="project-more-posts">
				<div class="d-flex justify-content-between align-items-center">
                    <?php if(!empty($settings['prev_text'])):?>
					    <a href="<?php echo esc_url($settings['prev_link']['url']);?>"><span class="fa fa-arrow-left"></span> &nbsp; <?php echo esc_html($settings['prev_text']);?></a>
                    <?php endif;?>
                    <?php if(!empty($settings['grid_img']['url'])):?>
					    <a href="#"><span class="icon"><img src="<?php echo esc_url($settings['grid_img']['url']);?>" alt="" /></span></a>
                    <?php endif;?>
					<a href="<?php echo esc_url($settings['next_link']['url']);?>"><?php echo esc_html($settings['next_text']);?> &nbsp; <span class="fa fa-arrow-right"></span></span></a>
				</div>
			</div>
			
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Project_Details() );