<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Progress extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-progress-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Progress Bar', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Accordions Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'skill_count', [
				'label' => esc_html__( 'Skill Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		
		$this->add_control(
			'progress_item',
			[
				'label' => esc_html__( 'Progress Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="default-skills">
        <?php foreach($settings['progress_item'] as $item):?>
        <div class="default-skill-item">
            <div class="default-skill-title"><?php echo esc_html($item['title']);?></div>
            <div class="default-skill-bar">
                <div class="default-bar-inner">
                    <div class="default-bar progress-line" data-width="<?php echo esc_attr($item['skill_count']);?>">
                        <div class="default-skill-percentage"></div>
                    </div>
                </div>
            </div>
            <div class="default-count-box count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr($item['skill_count']);?>">0</span>%</div>
        </div>
        <?php endforeach;?>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Progress() );