<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Member_Block extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-fnf-member-block-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Member Block', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'member_logo', [
				'label' => esc_html__( 'Member Logo', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'member_counter', [
				'label' => esc_html__( 'Member Counter Text', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'signature_img', [
				'label' => esc_html__( 'Signature Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="team-section">
        <div class="member-block">
            <div class="inner-box">
                <div class="content">
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['member_logo']['url']);?>" alt="" />
                    </div>
                    <h4 class="title-anim"><a href="<?php echo esc_url($settings['link']['url']);?>"><?php echo esc_html($settings['title']);?></a></h4>
                    <div class="text title-anim"><?php echo wp_kses( $settings['description'], true )?></div>
                </div>
                <div class="member"><?php echo wp_kses( $settings['member_counter'], true )?></div>
                <!-- Signature -->
                <?php if(!empty($settings['signature_img']['url'])):?>
                    <div class="signature"><img src="<?php echo esc_url($settings['signature_img']['url']);?>" alt="" /></div>
                <?php endif;?>
            </div>
        </div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Member_Block() );