<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Main_Slider4 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-main-slider4';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Main slider 4', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'bg', [
				'label' => esc_html__( 'Background image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'ttl',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'sub',
            [
                'label' => esc_html__('Sub title', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'btn',
            [
                'label' => esc_html__('Button label', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'thepack'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

		$this->add_control(
            'items',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ ttl }}}',
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        $out1 = '';
        foreach ($settings['items'] as $item) {

			$ttl = $item['ttl'] ? '<h1 class="slider-four_title">'.$item['ttl'].'</h1>' : '';
			$sub = $item['sub'] ? '<div class="slider_four-sub-title">'.$item['sub'].'</div>' : '';
            $out1 .= '
				<div class="slide">
					<div class="auto-container">
						<div class="content">
							'.$ttl.'
							<div class="d-flex justify-content-between align-items-center flex-wrap">
								'.$sub.'
								<!-- Button Box -->
								<div class="slider-four_button">
									<a class="btn-style-five theme-btn btn-item" href="'.$item['link'].'">
										<div class="btn-wrap">
											<span class="text-one">'.$item['btn'].'</span>
											<span class="text-two">'.$item['btn'].'</span>
										</div>
										<i class="arrow fa-solid fa-arrow-right fa-fw"></i>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>			
			';
        }		
    ?>
		<div class="main-slider_four" style="background-image:url(<?php echo esc_url($settings['bg']['url']);?>)">
			<div class="single-item-carousel owl-carousel owl-theme">				
				<!-- Slide -->
					<?php echo $out1;?>
				<!-- Slide -->			
			</div>
		</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Main_Slider4() );