<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class hire_us extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hire-us';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hire Us', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'section_bg',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('Section BG', 'thepack'),
            ]
        );

		$this->add_control(
            'title',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'label' => esc_html__('Title', 'thepack'),
                'default' => __('To Hire us or Need Any Urgent Help? <span>Email or Call</span> us Anytime!', 'thepack'),
            ]
        );

		$this->add_control(
            'call_us_text',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Call Us Text', 'thepack'),
                'default' => esc_html__('Call us today:', 'thepack'),
            ]
        );
		$this->add_control(
            'phone_number',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Phone Number', 'thepack'),
                'default' => __('03504 687 212:', 'thepack'),
            ]
        );
		$this->add_control(
            'or',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Middle Text', 'thepack'),
                'default' => __('or', 'thepack'),
            ]
        );
		$this->add_control(
            'email_text',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Email Text', 'thepack'),
                'default' => __('Email us at', 'thepack'),
            ]
        );
		$this->add_control(
            'email_address',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Email Address', 'thepack'),
                'default' => __('office@envato.com', 'thepack'),
            ]
        );
		$this->add_control(
            'btn_text',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Button Text', 'thepack'),
                'default' => __('Read more', 'thepack'),
            ]
        );
		$this->add_control(
            'btn_link',
            [
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'label' => esc_html__('Button Link', 'thepack'),
            ]
        );
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Project List', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
                        'name' => 'project_img',
						'type' => Controls_Manager::MEDIA,
						'label_block' => true,
						'label' => esc_html__('Project Image', 'thepack'),
					],
					[
						'name' => 'project_number',
						'type' => Controls_Manager::NUMBER,
						'label_block' => true,
						'label' => esc_html__('Project Number', 'thepack'),
						'default' => __('12', 'thepack'),
					],
					[
						'name' => 'suffix',
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'label' => esc_html__('Number Suffix', 'thepack'),
						'default' => __('+', 'thepack'),
					],
					[
						'name' => 'project_title',
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'label' => esc_html__('Project Title', 'thepack'),
						'default' => __('Project Complete', 'thepack'),
					],
				],
				'default' => [
					[
						'project_title' => esc_html__( 'Project Complete', 'textdomain' ),
					],
					[
						'project_title' => esc_html__( 'HAPPY CLIENTS', 'textdomain' ),
					],
				],
				'title_field' => '{{{ project_title }}}',
			]
		);

		$this->add_control(
            'right_bg',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('Right Image', 'thepack'),
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .help-one_title',
			]
		);

		$this->add_control(
			'--Contact-Info-Style--',
			[
				'label' => esc_html__( 'Contact Info Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Contact-Info-Color',
			[
				'label' => esc_html__( 'Contact Info Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Contact-Info-Typography',
				'label' => esc_html__( 'Contact Info Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .help-one_text',
			]
		);
		$this->add_control(
			'Contact-Info-Border-Color',
			[
				'label' => esc_html__( 'Contact Info Border Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_text span' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Contact-Info-Styled-Text-Color',
			[
				'label' => esc_html__( 'Contact Info Styled Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_text a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Contact-Info-Styled-Text-Typography',
				'label' => esc_html__( 'Contact Info Styled Text Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .help-one_text a',
			]
		);
		$this->add_control(
			'--Button-Style--',
			[
				'label' => esc_html__( 'Button Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Color',
			[
				'label' => esc_html__( 'Button Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five .btn-wrap .text-one' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Typography',
				'label' => esc_html__( 'Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .btn-style-five',
			]
		);
		$this->add_control(
			'Button-Background-Color',
			[
				'label' => esc_html__( 'Button Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Hover-Color',
			[
				'label' => esc_html__( 'Button Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover .btn-wrap .text-two' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five:hover .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-Background-Color',
			[
				'label' => esc_html__( 'Button Hover Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'Project_style_1',
			[
				'label' => __( 'Project Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'--Counter-Style--',
			[
				'label' => esc_html__( 'Counter Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Counter-Number-Color',
			[
				'label' => esc_html__( 'Counter Number Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_counter' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Counter-Number-Typography',
				'label' => esc_html__( 'Counter Number Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .help-one_counter',
			]
		);
		$this->add_control(
			'Counter-Title-Color',
			[
				'label' => esc_html__( 'Counter Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .help-one_counter-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Counter-Title-Typography',
				'label' => esc_html__( 'Counter Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .help-one_counter-text',
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
		
    ?>
        <!-- Help One -->
        <div class="help-one">
            <div class="help-one_image-layer" style="background-image:url(<?php echo esc_url($settings['section_bg']['url']); ?>)"></div>
            <div class="auto-container">
                <div class="help-one_content-box">
                    <h2 class="help-one_title"><?php echo wp_kses($settings['title'], true); ?></h2>
                    <div class="help-one_text"><span><?php echo esc_html( $settings['call_us_text'] ); ?></span> <a href="tel:+<?php echo $settings['phone_number']; ?>"><?php echo esc_html( $settings['phone_number'] ); ?></a> <?php echo esc_html( $settings['or'] ); ?> <span><?php echo esc_html( $settings['email_text'] ); ?></span> <a href="mailto:<?php echo $settings['email_address']; ?>"><?php echo esc_html( $settings['email_address'] ); ?></a></div>
                    <?php if (!empty($settings['btn_text'])): ?>
                    <a class="btn-style-five theme-btn btn-item" href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>" target="<?php if ($settings['btn_link']['is_external']) echo '_blank'; ?>">
                        <div class="btn-wrap">
                            <span class="text-one"><?php echo esc_html( $settings['btn_text'] ); ?></span>
                            <span class="text-two"><?php echo esc_html( $settings['btn_text'] ); ?></span>
                        </div>
                        <i class="arrow fa-solid fa-arrow-right fa-fw"></i>
                    </a>
                    <?php endif; ?>
                    <div class="row clearfix">

                        <!-- Help One Block -->
                        <?php foreach ($settings['list'] as $item): ?>
                        <div class="help-one_block col-lg-6 col-md-6 col-sm-12">
                            <div class="help-one_block-inner">
                                <div class="help-one_block-image">
                                    <img src="<?php echo esc_url( $item['project_img']['url'] ); ?>" alt="" />
                                    <div class="help-one_overlay">
                                        <div class="help-one_counter"><span class="odometer" data-count="<?php echo esc_attr($item['project_number']) ?>"></span><?php echo esc_html( $item['suffix'] ); ?></div>
                                        <div class="help-one_counter-text"><?php echo esc_html( $item['project_title'] ); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>


                    </div>
                </div>
            </div>
            <?php if (!empty($settings['right_bg']['url'])): ?>
                <div class="help-one_side-image">
                    <img src="<?php echo esc_url($settings['right_bg']['url']); ?>" alt="" />
                </div>
            <?php endif; ?>
        </div>
        <!-- End Help One -->
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new hire_us() );