<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Hero_BG_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-hero-video-slider-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero Video', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Slider Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'video_poster', [
				'label' => esc_html__( 'Video Poster Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
        $this->add_control(
			'self_host_video',
			[
				'label' => esc_html__( 'Choose File', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'media_type' => 'video',
			]
		);
		$this->add_control(
			'video_link', [
				'label' => esc_html__( 'Video Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button', [
				'label' => esc_html__( 'Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_arrow', [
				'label' => esc_html__( 'Button Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="main-slider-two">
		<div class="auto-container">
            <video autoplay="" loop="" muted="" width="100%" height="100%" poster="<?php echo esc_url($settings['video_poster']['url']);?>">
                <?php if(!empty($settings['self_host_video']['url'])):?>
				    <source type="video/mp4" src="<?php echo esc_url($settings['self_host_video']['url']);?>">
                <?php else:?>
                    <source type="video/mp4" src="<?php echo esc_url($settings['video_link']['url']);?>">
                <?php endif;?>
			</video>
			<div class="row clearfix">
				
				<!-- Content Column -->
				<div class="content-column col-lg-7 col-md-12 col-sm-12">
					<div class="inner-column">
                        <?php if(!empty($settings['subtitle'])):?>
						<div class="title"><?php echo wp_kses( $settings['subtitle'], true )?></div>
                        <?php endif;?>
						<h1><?php echo wp_kses( $settings['title'], true )?></h1>
						<div class="text"><?php echo wp_kses( $settings['description'], true )?></div>
						<!-- Button Box -->
                        <?php if(!empty($settings['button'])):?>
						<div class="button-box">
							<a class="btn-style-one theme-btn btn-item" href="<?php echo esc_url($settings['button_link']['url']);?>">
								<div class="btn-wrap">
									<span class="text-one"><?php echo esc_html($settings['button']);?></span>
									<span class="text-two"><?php echo esc_html($settings['button']);?></span>
								</div>
								<i class="arrow"><img src="<?php echo esc_url($settings['button_arrow']['url']);?>" alt="" /></i>
							</a>
						</div>
                        <?php endif;?>
					</div>
				</div>
				
			</div>
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Hero_BG_Slider() );