<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Hero_Slider_2 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-hero-slider-2-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero Slider Two', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Slider Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape 1', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'shape4', [
				'label' => esc_html__( 'Shape 4', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'shape5', [
				'label' => esc_html__( 'Shape 5', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'shape6', [
				'label' => esc_html__( 'Shape 6', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'hero_img', [
				'label' => esc_html__( 'Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'hero_img2', [
				'label' => esc_html__( 'Image 2', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		

		$repeater->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'sliders',
			[
				'label' => esc_html__( 'Add Slider Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <!-- Main Slider Three -->
	<div class="main-slider_three" <?php if(!empty($settings['shape']['url'])):?> style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)" <?php endif;?>>
        <?php if(!empty($settings['shape2']['url'])):?>
		    <div class="slider_three_shape-one" style="background-image:url(<?php echo esc_url($settings['shape2']['url']);?>)"></div>
        <?php endif;?>
        <?php if(!empty($settings['shape3']['url'])):?>
		    <div class="slider_three_shape-two" style="background-image:url(<?php echo esc_url($settings['shape3']['url']);?>)"></div>
        <?php endif;?>
        <?php if(!empty($settings['shape4']['url'])):?>
		    <div class="slider_three_shape-three" style="background-image:url(<?php echo esc_url($settings['shape4']['url']);?>)"></div>
        <?php endif;?>
        <?php if(!empty($settings['shape5']['url'])):?>
		    <div class="slider_three_shape-four" style="background-image:url(<?php echo esc_url($settings['shape5']['url']);?>)"></div>
        <?php endif;?>
        <?php if(!empty($settings['shape6']['url'])):?>
		    <div class="slider_three_shape-five" style="background-image:url(<?php echo esc_url($settings['shape6']['url']);?>)"></div>
        <?php endif;?>
        <?php if(!empty($settings['hero_img']['url'])):?>
            <div class="slider-three_image-one">
                <img src="<?php echo esc_url($settings['hero_img']['url']);?>" alt="" />
            </div>
        <?php endif;?>
        <?php if(!empty($settings['hero_img2']['url'])):?>
            <div class="slider-three_image-two">
                <img src="<?php echo esc_url($settings['hero_img2']['url']);?>" alt="" />
            </div>
        <?php endif;?>
		<div class="single-item-carousel owl-carousel owl-theme">
			
			<!-- Slide -->
            <?php foreach($settings['sliders'] as $item):?>
			<div class="slide">
				<div class="auto-container">
					<div class="content">
						<h1 class="slider-three_title"><?php echo wp_kses( $item['title'], true );?></h1>
						<!-- Button Box -->
						<div class="slider-three_button">
							<a class="btn-style-three theme-btn btn-item" href="<?php echo esc_url($item['button_link']['url']);?>">
								<div class="btn-wrap">
									<span class="text-one"><?php echo esc_html($item['button_label']);?></span>
									<span class="text-two"><?php echo esc_html($item['button_label']);?></span>
								</div>
								<i class="arrow fa-solid fa-arrow-right fa-fw"></i>
							</a>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach;?>
		</div>
	</div>
	<!-- End Main Slider -->
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Hero_Slider_2() );