<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Hero_Slider extends Widget_Base {
	
	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-hero-slider-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero Slider', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Slider Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'year_img', [
				'label' => esc_html__( 'Year Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'pattern', [
				'label' => esc_html__( 'Pattern', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic' ],
				'exclude' => [ 'color' ],
				'selector' => '{{WRAPPER}} .main-slider .content-column h1 span:before',
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'slide_img', [
				'label' => esc_html__( 'Slide Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'arrow', [
				'label' => esc_html__( 'Arrow Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'sliders',
			[
				'label' => esc_html__( 'Add Slider Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        
		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'thm_clr',
            [
                'label' => esc_html__('Theme color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider .content-column h1 span' => 'color: {{VALUE}};',
					'{{WRAPPER}} .btn-style-one,{{WRAPPER}} .main-slider .owl-nav' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_hd',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .main-slider .content-column h1',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider .content-column h1' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'd_hd',
            [
                'label' => esc_html__('Description', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'd_ty',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .main-slider .content-column .text',
            ]
        );

        $this->add_control(
            'd_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider .content-column .text' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'bt_hd',
            [
                'label' => esc_html__('Button', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bt_ty',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .btn-style-one',
            ]
        );

        $this->add_control(
            'bt_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="main-slider">
		<!-- Shape Outer -->
        <?php if(!empty($settings['shape']['url'])):?>
		<div class="shape-outer">
			<div class="shape-layer animation_mode" style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)"></div>
		</div>
        <?php endif;?>
		<!-- Years Box -->
        <?php if(!empty($settings['year_img']['url'])):?>
            <div class="years-box">
                <img src="<?php echo esc_url($settings['year_img']['url']);?>" alt="" />
            </div>
        <?php endif;?>
		<!-- Side Info -->
        <?php if(!empty($settings['title'])):?>
		<div class="side-info">
			<span class="fa fa-comments"></span><?php echo wp_kses( $settings['title'], true )?>
		</div>
		<?php endif;?>
		<div class="single-item-carousel owl-carousel owl-theme">
			
			
			
			<!-- Slide -->
            <?php foreach($settings['sliders'] as $item):?>
			<div class="slide">
                <?php if(!empty($settings['pattern']['url'])):?>
				    <div class="pattern-layer" style="background-image:url(<?php echo esc_url($settings['pattern']['url']);?>)"></div>
                <?php endif;?>
				<div class="auto-container">
					<div class="row clearfix">
						<!-- Image Column -->
                        <?php if(!empty($item['slide_img']['url'])):?>
						<div class="image-column col-lg-6 col-md-12 col-sm-12">
							<div class="inner-column">
								<div class="image">
									<img src="<?php echo esc_url($item['slide_img']['url']);?>" alt="" />
								</div>
							</div>
						</div>
                        <?php endif;?>
						<!-- Content Column -->
						<div class="content-column col-lg-6 col-md-12 col-sm-12">
							<div class="inner-column">      
								<h1><?php echo wp_kses( $item['title'], true )?></h1>
								<div class="text"><?php echo wp_kses( $item['description'], true )?></div>
								<!-- Button Box --> 
								<div class="button-box">
									<a class="btn-style-one theme-btn btn-item" href="<?php echo esc_url($item['button_link']['url']);?>">
										<div class="btn-wrap">
											<span class="text-one"><?php echo wp_kses( $item['button_label'], true )?></span>
											<span class="text-two"><?php echo wp_kses( $item['button_label'], true )?></span>
										</div>
                                        <?php if(!empty($item['arrow']['url'])):?>
										    <i class="arrow"><img src="<?php echo esc_url($item['arrow']['url']);?>" alt="" /></i>
                                        <?php endif;?>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
            <?php endforeach;?>
            
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Hero_Slider() );