<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Fnf_Three_Counter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-fnf-three-counter-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FanFact Three Counter', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'achivement_title', [
				'label' => esc_html__( 'Achivement Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count_no', [
				'label' => esc_html__( 'Counter Number', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'prefix', [
				'label' => esc_html__( 'Prefix', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'counters',
			[
				'label' => esc_html__( 'Add Counter Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="counter-section-three">
		<div class="auto-container">
			<div class="row clearfix">
				<!-- Counter Column -->
				<div class="counter-column col-lg-7 col-md-12 col-sm-12">
					<div class="inner-column">
						<div class="row clearfix">
				
							<!-- Counter Column -->
                            <?php foreach($settings['counters'] as $item):?>
							<div class="counter-block col-lg-4 col-md-6 col-sm-6">
								<div class="inner-box title-anim">
									<div class="counter"><span class="odometer" data-count="<?php echo esc_attr($item['count_no']);?>"></span><?php if(!empty($item['prefix'])){echo esc_attr($item['prefix']);}?></div>
									<div class="counter-text"><?php echo esc_html($item['title']);?></div>
								</div>
							</div>
							<?php endforeach;?>
						</div>
					</div>
				</div>
				<!-- Title Column -->
                <?php if(!empty($settings['achivement_title'])):?>
				<div class="title-column col-lg-5 col-md-12 col-sm-12">
					<div class="inner-column">
						<div class="title"><?php echo wp_kses( $settings['achivement_title'], true )?></div>
					</div>
				</div>
                <?php endif;?>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Fnf_Three_Counter() );