<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Fnf_Single_Counter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-fnf-single-counter-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FanFact Single Item', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'count_no', [
				'label' => esc_html__( 'Counter Number', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'prefix', [
				'label' => esc_html__( 'Prefix', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="team-section">
        <div class="counter">
            <div class="counter"><span class="odometer" data-count="<?php echo esc_attr($settings['count_no']);?>"></span><?php if(!empty($settings['prefix'])){ echo esc_attr($settings['prefix']);}?></div>
            <h6><?php echo esc_html($settings['title']);?></h6>
        </div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Fnf_Single_Counter() );