<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Fnf_Counter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-fnf-counter-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FanFact Counter', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count_no', [
				'label' => esc_html__( 'Counter Number', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'prefix', [
				'label' => esc_html__( 'Prefix', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'counters',
			[
				'label' => esc_html__( 'Add Counter Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Counter', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .counter-section .counter-block .counter',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-section .counter-block .counter' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'd_bg',
            [
                'label' => esc_html__('Counter', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'd_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .counter-section .counter-block .counter-text',
            ]
        );

        $this->add_control(
            'd_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-section .counter-block .counter-text' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="counter-section">
        <div class="auto-container">
			<div class="row clearfix">
				
				<!-- Counter Column -->
                <?php foreach($settings['counters'] as $item):?>
				<div class="counter-block col-lg-3 col-md-6 col-sm-6">
					<div class="inner-box title-anim">
						<div class="counter"><span class="odometer" data-count="<?php echo esc_attr($item['count_no'])?>"></span><?php echo esc_html($item['prefix']);?></div>
						<div class="counter-text"><?php echo esc_html($item['title']);?></div>
					</div>
				</div>
				<?php endforeach;?>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Fnf_Counter() );